var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button/Button";
import { SearchInput } from "@patternfly/react-core/dist/js/components/SearchInput";
import { Text, TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { TimesIcon } from "@patternfly/react-icons/dist/js/icons/times-icon";
import { useCallback, useMemo, useState } from "react";
import { DmnObjectListItem } from "../externalNodes/DmnObjectListItem";
import { DiagramLhsPanel } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { buildXmlHref } from "../xml/xmlHrefs";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { computeContainingDecisionServiceHrefsByDecisionHrefs } from "../store/computed/computeContainingDecisionServiceHrefsByDecisionHrefs.ts";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import CubesIcon from "@patternfly/react-icons/dist/js/icons/cubes-icon";
export var MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE = "kie-dmn-editor--drg-node";
export function DrgNodesPanel() {
    var thisDmnsDrgElements = useDmnEditorStore(function (s) { var _a; return (_a = s.dmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : []; });
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    var dmnShapesByHref = useDmnEditorStore(function (s) { return s.computed(s).indexedDrd().dmnShapesByHref; });
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _a = __read(useState(""), 2), filter = _a[0], setFilter = _a[1];
    var namespaceForHref = "";
    var onDragStart = useCallback(function (event, drgElement) {
        event.dataTransfer.setData(MIME_TYPE_FOR_DMN_EDITOR_DRG_NODE, JSON.stringify(drgElement));
        event.dataTransfer.effectAllowed = "move";
    }, []);
    var containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn = useMemo(function () {
        return computeContainingDecisionServiceHrefsByDecisionHrefs({
            drgElements: thisDmnsDrgElements,
            drgElementsNamespace: thisDmnsNamespace,
            thisDmnsNamespace: thisDmnsNamespace,
        });
    }, [thisDmnsDrgElements, thisDmnsNamespace]);
    var nodes = thisDmnsDrgElements
        .filter(function (drgElement) { return drgElement["@_name"].toLowerCase().includes(filter.toLowerCase()); })
        .map(function (drgElement) {
        var _a;
        var dmnObjectHref = buildXmlHref({ namespace: namespaceForHref, id: drgElement["@_id"] });
        var canBeIncluded = !dmnShapesByHref.has(dmnObjectHref) &&
            ((_a = containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn.get(dmnObjectHref)) !== null && _a !== void 0 ? _a : []).every(function (dsHref) { return !dmnShapesByHref.has(dsHref); });
        return (_jsx("div", __assign({ className: "kie-dmn-editor--external-nodes-list-item", draggable: canBeIncluded, style: {
                opacity: canBeIncluded ? undefined : 0.4,
                userSelect: "none",
            }, onDragStart: function (event) { return onDragStart(event, drgElement); } }, { children: _jsx(Flex, __assign({ alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentFlexStart" }, spaceItems: { default: "spaceItemsNone" } }, { children: _jsx(DmnObjectListItem, { dmnObjectHref: dmnObjectHref, dmnObject: drgElement, namespace: namespaceForHref, relativeToNamespace: namespaceForHref }) })) }), drgElement["@_id"]));
    });
    return (_jsx(_Fragment, { children: (nodes.length <= 0 && (_jsx(_Fragment, { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, __assign({ size: "md", headingLevel: "h4" }, { children: "No DRG nodes yet" })), _jsx(EmptyStateBody, { children: "Use the Palette on the left-hand-side to drag new nodes into the Diagram." })] }) }))) || (_jsxs(_Fragment, { children: [_jsxs("div", __assign({ className: "kie-dmn-editor--sticky-top-glass-header", style: { padding: "12px" } }, { children: [_jsxs(Flex, __assign({ justifyContent: { default: "justifyContentSpaceBetween" } }, { children: [_jsx(TextContent, { children: _jsx(Text, __assign({ component: "h3" }, { children: "DRG Nodes" })) }), _jsx(Button, __assign({ title: "Close", variant: ButtonVariant.plain, onClick: function () {
                                        return dmnEditorStoreApi.setState(function (state) {
                                            state.diagram.openLhsPanel = DiagramLhsPanel.NONE;
                                        });
                                    } }, { children: _jsx(TimesIcon, {}) }))] })), _jsx(Divider, { style: { marginBottom: "12px" } }), _jsx(SearchInput, { style: { marginBottom: "12px", height: "36px" }, onKeyDown: function (e) { return e.stopPropagation(); }, autoFocus: true, placeholder: "Filter...", value: filter, onChange: function (_event, value) { return setFilter(value); }, onClear: function () { return setFilter(""); } })] })), _jsx("div", __assign({ style: { padding: "12px" } }, { children: nodes }))] })) }));
}
//# sourceMappingURL=DrgNodesPanel.js.map