var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo, useState, useCallback, useRef, useEffect } from "react";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { FeelInput } from "@kie-tools/feel-input-component/dist";
import "./ConstraintsExpression.css";
import { HelperText, HelperTextItem } from "@patternfly/react-core/dist/js/components/HelperText";
import InfoIcon from "@patternfly/react-icons/dist/js/icons/info-icon";
export function ConstraintsExpression(_a) {
    var id = _a.id, isReadonly = _a.isReadonly, value = _a.value, onSave = _a.onSave;
    var _b = __read(useState(value !== null && value !== void 0 ? value : ""), 2), preview = _b[0], setPreview = _b[1];
    var _c = __read(useState(false), 2), isEditing = _c[0], setEditing = _c[1];
    var valueCopy = useRef(value);
    var onFeelBlur = useCallback(function (valueOnBlur) {
        setEditing(false);
    }, []);
    var onFeelChange = useCallback(function (_, content, preview) {
        setPreview(preview);
        onSave === null || onSave === void 0 ? void 0 : onSave(content.trim());
    }, [onSave]);
    var onPreviewChanged = useCallback(function (newPreview) { return setPreview(newPreview); }, []);
    useEffect(function () {
        valueCopy.current = isEditing ? valueCopy.current : value;
    }, [isEditing, value]);
    var onKeyDown = useCallback(function (e) {
        if (!isReadonly && isEditing) {
            e.stopPropagation();
        }
        if (!isReadonly && !isEditing) {
            setEditing(true);
        }
    }, [isEditing, isReadonly]);
    var monacoOptions = useMemo(function () { return ({
        fixedOverflowWidgets: true,
        lineNumbers: "off",
        fontSize: 16,
        renderLineHighlight: "none",
        lineDecorationsWidth: 1,
        automaticLayout: true,
        "semanticHighlighting.enabled": true,
    }); }, []);
    return (_jsxs("div", __assign({ style: { display: "flex", flexDirection: "column", width: "100%" }, onKeyDown: onKeyDown }, { children: [isReadonly && (_jsx(Title, __assign({ size: "md", headingLevel: "h5", style: { paddingBottom: "10px" } }, { children: "Equivalent FEEL expression:" }))), _jsxs("div", __assign({ style: !isReadonly
                    ? { flexGrow: 1, flexShrink: 0, border: "solid 1px lightgray", borderRadius: "4px" }
                    : { flexGrow: 1, flexShrink: 0, height: "22px" } }, { children: [isReadonly &&
                        (value ? (_jsx("span", { className: "editable-cell-value pf-u-text-break-word", dangerouslySetInnerHTML: { __html: preview } })) : (_jsx("p", __assign({ style: { fontStyle: "italic" } }, { children: "<None>" })))), _jsx(FeelInput, { value: isEditing ? valueCopy.current : value, onChange: onFeelChange, onBlur: onFeelBlur, onPreviewChanged: onPreviewChanged, enabled: !isReadonly, options: monacoOptions })] })), _jsx(HelperText, { children: !isReadonly && (_jsxs(HelperTextItem, __assign({ variant: "indeterminate", icon: _jsx(InfoIcon, {}) }, { children: ["Check the", " ", _jsx("a", __assign({ target: "_blank", href: "https://kiegroup.github.io/dmn-feel-handbook/#feel-values" }, { children: "FEEL handbook" })), " ", "to help you on creating your expressions."] }))) })] }), id));
}
//# sourceMappingURL=ConstraintsExpression.js.map