var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo, useState, useCallback, useRef } from "react";
import { ConstraintsExpression } from "./ConstraintsExpression";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import PlusCircleIcon from "@patternfly/react-icons/dist/js/icons/plus-circle-icon";
import { Draggable, DragAndDrop, useDraggableItemContext } from "../draggable/Draggable";
import TimesIcon from "@patternfly/react-icons/dist/js/icons/times-icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export var ENUM_SEPARATOR = ",";
export function ConstraintsEnum(_a) {
    var _b;
    var id = _a.id, isReadonly = _a.isReadonly, value = _a.value, expressionValue = _a.expressionValue, type = _a.type, typeHelper = _a.typeHelper, onSave = _a.onSave, isDisabled = _a.isDisabled, renderOnPropertiesPanel = _a.renderOnPropertiesPanel;
    var enumValues = useMemo(function () { var _a; return (_a = isEnum(value, typeHelper.check)) !== null && _a !== void 0 ? _a : [""]; }, [typeHelper.check, value]);
    var _c = __read(useState((_b = (enumValues !== null && enumValues !== void 0 ? enumValues : [""])) === null || _b === void 0 ? void 0 : _b.map(function (_) { return generateUuid(); })), 2), valuesUuid = _c[0], setValuesUuid = _c[1];
    var isItemValid = useMemo(function () { return enumValues.map(function (value, i, array) { return array.filter(function (e) { return e === value; }).length <= 1; }); }, [enumValues]);
    var _d = __read(useState(""), 2), focusOwner = _d[0], setFocusOwner = _d[1];
    var onAdd = useCallback(function () {
        setValuesUuid(function (prev) {
            if (prev[enumValues.length] === undefined) {
                var newValuesUuid = __spreadArray([], __read(prev), false);
                newValuesUuid[enumValues.length] = generateUuid();
                return newValuesUuid;
            }
            return prev;
        });
        onSave(enumValues.join("".concat(ENUM_SEPARATOR, " ")) + ENUM_SEPARATOR);
        setFocusOwner("");
    }, [onSave, enumValues]);
    var onRemove = useCallback(function (index) {
        var newValues = __spreadArray([], __read(enumValues), false);
        newValues.splice(index, 1);
        setValuesUuid(function (prev) {
            var newUuids = __spreadArray([], __read(prev), false);
            newUuids.splice(index, 1);
            return newUuids;
        });
        onSave(newValues.join("".concat(ENUM_SEPARATOR, " ")));
    }, [enumValues, onSave]);
    var onDragEnd = useCallback(function (source, dest) {
        var reordened = __spreadArray([], __read(enumValues), false);
        var _a = __read(reordened.splice(source, 1), 1), removed = _a[0];
        reordened.splice(dest, 0, removed);
        onSave(reordened.join("".concat(ENUM_SEPARATOR, " ")));
    }, [enumValues, onSave]);
    var reorder = useCallback(function (source, dest) {
        setValuesUuid(function (prev) {
            var reordenedUuid = __spreadArray([], __read(prev), false);
            var _a = __read(reordenedUuid.splice(source, 1), 1), removedUuid = _a[0];
            reordenedUuid.splice(dest, 0, removedUuid);
            return reordenedUuid;
        });
    }, []);
    var onChangeItem = useCallback(function (newValue, index) {
        var newValues = __spreadArray([], __read(enumValues), false);
        newValues[index] = typeHelper.transform(newValue);
        onSave(newValues.join("".concat(ENUM_SEPARATOR, " ")));
    }, [enumValues, onSave, typeHelper]);
    var draggableItem = useCallback(function (value, index) {
        var _a;
        return (_jsx(Draggable, __assign({ index: index, style: { alignItems: "center" }, handlerStyle: { margin: "0px 10px" }, isDisabled: isReadonly || isDisabled }, { children: _jsx("li", __assign({ style: { marginLeft: "20px", listStyleType: "initial" } }, { children: _jsx(EnumElement, { id: "enum-element-".concat(index), isDisabled: isReadonly || isDisabled, initialValue: (_a = typeHelper.recover(value)) !== null && _a !== void 0 ? _a : "", onChange: function (newValue) { return onChangeItem(newValue, index); }, onRemove: function () { return onRemove(index); }, isValid: isItemValid[index], focusOwner: focusOwner, setFocusOwner: setFocusOwner, typeHelper: typeHelper, onKeyDown: function (e) {
                        if (e.key === "Enter") {
                            onAdd();
                        }
                        if (e.key === ENUM_SEPARATOR) {
                            e.preventDefault();
                        }
                    } }) })) }), valuesUuid[index]));
    }, [focusOwner, isDisabled, isItemValid, isReadonly, onAdd, onChangeItem, onRemove, typeHelper, valuesUuid]);
    return (_jsxs("div", { children: [_jsx("div", { children: _jsx("div", __assign({ style: {
                        display: "flex",
                        flexDirection: "column",
                        gap: "10px",
                        border: "solid 1px lightgray",
                        borderRadius: "4px",
                    } }, { children: _jsx("ul", { children: _jsx(DragAndDrop, { reorder: reorder, onDragEnd: onDragEnd, values: enumValues, draggableItem: draggableItem, isDisabled: isDisabled || isReadonly }) }) })) }), !(isDisabled || isReadonly) && (_jsx(_Fragment, { children: _jsx(Button, __assign({ title: "Add enum value", onClick: function () { return onAdd(); }, variant: ButtonVariant.link, icon: _jsx(PlusCircleIcon, {}), style: { paddingTop: "10px", paddingBottom: 0, paddingLeft: 0, paddingRight: 0 } }, { children: "Add value" })) })), !renderOnPropertiesPanel && (_jsxs(_Fragment, { children: [_jsx("br", {}), _jsx("br", {}), _jsx(ConstraintsExpression, { id: id, isReadonly: true, value: expressionValue !== null && expressionValue !== void 0 ? expressionValue : "", type: type })] }))] }));
}
function EnumElement(_a) {
    var id = _a.id, isDisabled = _a.isDisabled, initialValue = _a.initialValue, isValid = _a.isValid, typeHelper = _a.typeHelper, focusOwner = _a.focusOwner, setFocusOwner = _a.setFocusOwner, onChange = _a.onChange, onRemove = _a.onRemove, onKeyDown = _a.onKeyDown;
    var value = useMemo(function () { return initialValue; }, [initialValue]);
    var removeButtonRef = useRef(null);
    var hovered = useDraggableItemContext().hovered;
    return (_jsxs("div", __assign({ style: { display: "flex", flexDirection: "row", justifyContent: "space-between" } }, { children: [typeHelper.component({
                autoFocus: true,
                onChange: function (newValue) { return onChange(newValue); },
                id: id,
                isDisabled: isDisabled,
                style: {
                    borderColor: "transparent",
                    backgroundColor: "transparent",
                    outline: "none",
                },
                value: value,
                focusOwner: focusOwner,
                setFocusOwner: setFocusOwner,
                isValid: isValid,
                onKeyDown: onKeyDown,
            }), _jsx(Button, { title: "Remove enum value", ref: removeButtonRef, style: { opacity: hovered ? "100%" : "0" }, className: "kie-dmn-editor--documentation-link--row-remove", variant: "plain", icon: _jsx(TimesIcon, {}), onClick: function () { return onRemove(); } }), hovered && _jsx(Tooltip, { content: "Remove", reference: removeButtonRef })] })));
}
export function isEnum(value, typeCheck) {
    if (value === undefined) {
        return undefined;
    }
    if (value === "") {
        return undefined;
    }
    var enumValues = value.split(ENUM_SEPARATOR).map(function (e) { return e.trim(); });
    if (enumValues.reduce(function (isEnum, value) { return isEnum && (typeCheck === null || typeCheck === void 0 ? void 0 : typeCheck(value)); }, true)) {
        return enumValues;
    }
    return undefined;
}
//# sourceMappingURL=ConstraintsEnum.js.map