var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useContext, useRef } from "react";
var CommandsContext = React.createContext({});
export function useCommands() {
    return useContext(CommandsContext);
}
export function CommandsContextProvider(props) {
    var commandsRef = useRef({
        hideFromDrd: function () {
            throw new Error("DMN EDITOR: hideFromDrd command not implemented.");
        },
        toggleHierarchyHighlight: function () {
            throw new Error("DMN EDITOR: toggleHierarchyHighlight command not implemented.");
        },
        togglePropertiesPanel: function () {
            throw new Error("DMN EDITOR: togglePropertiesPanel command not implemented.");
        },
        createGroup: function () {
            throw new Error("DMN EDITOR: createGroup command not implemented.");
        },
        selectAll: function () {
            throw new Error("DMN EDITOR: selectAll command not implemented.");
        },
        paste: function () {
            throw new Error("DMN EDITOR: paste command not implemented.");
        },
        copy: function () {
            throw new Error("DMN EDITOR: copy command not implemented.");
        },
        cut: function () {
            throw new Error("DMN EDITOR: cut command not implemented.");
        },
        cancelAction: function () {
            throw new Error("DMN EDITOR: cancelAction command not implemented.");
        },
        focusOnSelection: function () {
            throw new Error("DMN EDITOR: focusOnSelection command not implemented.");
        },
        resetPosition: function () {
            throw new Error("DMN EDITOR: resetPosition command not implemented.");
        },
    });
    return _jsx(CommandsContext.Provider, __assign({ value: { commandsRef: commandsRef } }, { children: props.children }));
}
//# sourceMappingURL=CommandsContextProvider.js.map