"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertSource = void 0;
var api_1 = require("../../../api");
function convertSource(catalogSource) {
    if ((catalogSource === null || catalogSource === void 0 ? void 0 : catalogSource.type) === api_1.SwfCatalogSourceType.LOCAL_FS) {
        return {
            type: catalogSource.type,
            serviceFileAbsolutePath: catalogSource.absoluteFilePath,
        };
    }
    return {
        type: catalogSource.type,
        registry: catalogSource.registry,
        serviceId: catalogSource.id,
    };
}
exports.convertSource = convertSource;
//# sourceMappingURL=convertSource.js.map