import * as React from "react";
import { useMemo } from "react";
import { Link } from "react-router-dom";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Breadcrumb, BreadcrumbItem } from "@patternfly/react-core/dist/js/components/Breadcrumb";
import { PageTitle } from "../PageTitle";
import { componentOuiaProps } from "../../ouiaTools";
export const PageSectionHeader = ({ titleText, breadcrumbText, breadcrumbPath, ouiaId, ouiaSafe, }) => {
    const breadcrumbContent = useMemo(() => {
        const items = [];
        if (!breadcrumbPath || !breadcrumbText) {
            return;
        }
        breadcrumbText === null || breadcrumbText === void 0 ? void 0 : breadcrumbText.forEach((text, index) => {
            if (index === breadcrumbText.length - 1) {
                items.push(React.createElement(BreadcrumbItem, { key: index, isActive: true }, text));
            }
            else {
                items.push(React.createElement(BreadcrumbItem, { key: index },
                    React.createElement(Link, { to: breadcrumbPath[index] }, text)));
            }
        });
        return items;
    }, [breadcrumbPath, breadcrumbText]);
    return (React.createElement(PageSection, Object.assign({ variant: "light" }, componentOuiaProps(ouiaId, "page-section-header", ouiaSafe)),
        breadcrumbContent && React.createElement(Breadcrumb, null, breadcrumbContent),
        React.createElement(PageTitle, { title: titleText })));
};
//# sourceMappingURL=PageSectionHeader.js.map