import { Page, PageHeader, PageHeaderTools, PageSidebar } from "@patternfly/react-core/dist/js/components/Page";
import React, { useEffect, useState, useMemo, useCallback } from "react";
import { componentOuiaProps, ouiaAttribute } from "../../ouiaTools";
import "../styles.css";
import { Brand } from "@patternfly/react-core/dist/js/components/Brand";
import { BrandContext } from "../../contexts/BrandContext/BrandContext";
import PageToolbar from "../PageToolbar/PageToolbar";
const PageLayout = ({ children, BrandSrc, PageNav, pageNavOpen, BrandAltText, BrandClick, ouiaId, ouiaSafe, withHeader, }) => {
    const pageId = "main-content-page-layout-default-nav";
    const [isNavOpen, setIsNavOpen] = useState(pageNavOpen != undefined ? pageNavOpen : true);
    const onNavToggle = useCallback(() => {
        setIsNavOpen((currentValue) => !currentValue);
    }, []);
    useEffect(() => {
        var _a;
        if (document.getElementById(pageId)) {
            (_a = document.getElementById(pageId)) === null || _a === void 0 ? void 0 : _a.setAttribute("data-ouia-main", "true");
        }
    });
    const Header = useMemo(() => {
        if (!withHeader || !BrandSrc) {
            return;
        }
        return (React.createElement(PageHeader, Object.assign({ logo: React.createElement(Brand, { src: BrandSrc, alt: BrandAltText !== null && BrandAltText !== void 0 ? BrandAltText : "", onClick: BrandClick }), headerTools: React.createElement(PageHeaderTools, null,
                React.createElement(BrandContext.Provider, { value: {
                        imageSrc: BrandSrc,
                        altText: BrandAltText !== null && BrandAltText !== void 0 ? BrandAltText : "",
                    } },
                    React.createElement(PageToolbar, null))), showNavToggle: true, isNavOpen: isNavOpen, onNavToggle: onNavToggle }, ouiaAttribute("data-ouia-header", "true"))));
    }, [BrandAltText, BrandClick, BrandSrc, isNavOpen, onNavToggle, withHeader]);
    const Sidebar = (React.createElement(PageSidebar, Object.assign({ nav: PageNav, isNavOpen: isNavOpen, theme: "dark" }, ouiaAttribute("data-ouia-navigation", "true"), { "data-testid": "page-sidebar" })));
    return (React.createElement(React.Fragment, null,
        React.createElement(Page, Object.assign({ header: Header, mainContainerId: pageId, sidebar: Sidebar, className: "kogito-consoles-common--PageLayout" }, componentOuiaProps(ouiaId, "page", ouiaSafe)), children)));
};
export default PageLayout;
//# sourceMappingURL=PageLayout.js.map