import React from "react";
import { EmptyState, EmptyStateBody, EmptyStateIcon, EmptyStateVariant, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { SearchIcon } from "@patternfly/react-icons/dist/js/icons/search-icon";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { ExclamationTriangleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon";
import { componentOuiaProps } from "../../ouiaTools";
export var KogitoEmptyStateType;
(function (KogitoEmptyStateType) {
    KogitoEmptyStateType[KogitoEmptyStateType["Search"] = 0] = "Search";
    KogitoEmptyStateType[KogitoEmptyStateType["Refresh"] = 1] = "Refresh";
    KogitoEmptyStateType[KogitoEmptyStateType["Reset"] = 2] = "Reset";
    KogitoEmptyStateType[KogitoEmptyStateType["Info"] = 3] = "Info";
})(KogitoEmptyStateType || (KogitoEmptyStateType = {}));
export const KogitoEmptyState = ({ type, title, body, onClick, ouiaId, ouiaSafe }) => {
    return (React.createElement(Bullseye, Object.assign({}, componentOuiaProps(ouiaId, "kogito-empty-state", ouiaSafe)),
        React.createElement(EmptyState, { variant: EmptyStateVariant.full },
            type === KogitoEmptyStateType.Search && React.createElement(EmptyStateIcon, { icon: SearchIcon }),
            (type === KogitoEmptyStateType.Refresh || type === KogitoEmptyStateType.Reset) && (React.createElement(EmptyStateIcon, { icon: ExclamationTriangleIcon, color: "var(--pf-global--warning-color--100)" })),
            type === KogitoEmptyStateType.Info && (React.createElement(EmptyStateIcon, { icon: InfoCircleIcon, color: "var(--pf-global--info-color--100)" })),
            React.createElement(Title, { headingLevel: "h5", size: "lg" }, title),
            React.createElement(EmptyStateBody, null, body),
            type === KogitoEmptyStateType.Refresh && (React.createElement(Button, { variant: "primary", onClick: onClick }, "Refresh")),
            type === KogitoEmptyStateType.Reset && (React.createElement(Button, { variant: "link", onClick: onClick }, "Reset to default")))));
};
export default KogitoEmptyState;
//# sourceMappingURL=KogitoEmptyState.js.map