"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMarshaller = void 0;
var xml_parser_ts_1 = require("@kie-tools/xml-parser-ts");
var meta_1 = require("./schemas/scesim-1_8/ts-gen/meta");
function getMarshaller(xml) {
    var domdoc = xml_parser_ts_1.domParser.getDomDocument(xml);
    var instanceNs = (0, xml_parser_ts_1.getInstanceNs)(domdoc);
    var p = (0, xml_parser_ts_1.getParser)({
        ns: meta_1.ns,
        meta: meta_1.meta,
        subs: meta_1.subs,
        elements: meta_1.elements,
        root: meta_1.root,
    });
    return {
        instanceNs: instanceNs,
        version: "1.8",
        root: meta_1.root,
        meta: meta_1.meta,
        parser: { parse: function () { return p.parse({ type: "domdoc", domdoc: domdoc, instanceNs: instanceNs }).json; } },
        builder: { build: function (json) { return p.build({ json: json, instanceNs: instanceNs }); } },
    };
}
exports.getMarshaller = getMarshaller;
//# sourceMappingURL=index.js.map