"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.flattenObj = exports.parseVarsForDotEnvPrint = exports.findEnv = exports.requireEnv = exports.BUILD_ENV_RECURSION_STOP_FILE_NAME = exports.ERROR_ACCESS_LOG_FILE_ABSOLUTE_PATH_ENV_VAR_NAME = void 0;
var index_1 = require("./index");
var console_logs_1 = require("./console_logs");
var path = require("path");
var fs = require("fs");
exports.ERROR_ACCESS_LOG_FILE_ABSOLUTE_PATH_ENV_VAR_NAME = "BUILD_ENV__accessErrorsLogFileAbsolutePath";
exports.BUILD_ENV_RECURSION_STOP_FILE_NAME = ".build-env-root";
function requireEnv(curDir) {
    return __awaiter(this, void 0, void 0, function () {
        var envPathJs, envPathCjs, envPathJsExists, envPathCjsExists, envFilePath, e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    envPathJs = path.resolve(curDir, "env", "index.js");
                    envPathCjs = path.resolve(curDir, "env", "index.cjs");
                    envPathJsExists = fs.existsSync(envPathJs);
                    envPathCjsExists = fs.existsSync(envPathCjs);
                    if (!envPathJsExists && !envPathCjsExists) {
                        return [2, undefined];
                    }
                    envFilePath = envPathJsExists ? envPathJs : envPathCjs;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4, Promise.resolve().then(function () { return require(envFilePath); })];
                case 2: return [2, (_a.sent())];
                case 3:
                    e_1 = _a.sent();
                    console.error(console_logs_1.LOGS.error.envFileLoadingError({ envFilePath: envFilePath }));
                    console.error(e_1);
                    throw new Error("[build-env] env-loading-error");
                case 4: return [2];
            }
        });
    });
}
exports.requireEnv = requireEnv;
function findEnv(startDir, curDir) {
    return __awaiter(this, void 0, void 0, function () {
        var env, envRecursionStopPath;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, requireEnv(curDir)];
                case 1:
                    env = _a.sent();
                    if (env) {
                        return [2, env];
                    }
                    envRecursionStopPath = path.resolve(curDir, exports.BUILD_ENV_RECURSION_STOP_FILE_NAME);
                    if (fs.existsSync(envRecursionStopPath)) {
                        console.error(console_logs_1.LOGS.error.findEnvRecursionStopped({ startDir: startDir, curDir: curDir, envRecursionStopPath: envRecursionStopPath }));
                        throw new Error("[build-env] env-loading-error");
                    }
                    return [2, findEnv(startDir, path.dirname(curDir))];
            }
        });
    });
}
exports.findEnv = findEnv;
function parseVarsForDotEnvPrint(vars) {
    var _a;
    var result = {};
    for (var v in vars) {
        result[v] = (_a = (0, index_1.getOrDefault)(vars[v])) !== null && _a !== void 0 ? _a : "";
    }
    return result;
}
exports.parseVarsForDotEnvPrint = parseVarsForDotEnvPrint;
function flattenObj(obj, parent, res) {
    if (parent === void 0) { parent = undefined; }
    if (res === void 0) { res = {}; }
    for (var key in obj) {
        var propName = parent ? parent + "." + key : key;
        if (typeof obj[key] == "object") {
            flattenObj(obj[key], propName, res);
        }
        else {
            res[propName] = obj[key];
        }
    }
    return res;
}
exports.flattenObj = flattenObj;
//# sourceMappingURL=lib.js.map