"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetKnativeService = exports.DeleteKnativeService = exports.ListKnativeServices = exports.CreateKnativeService = exports.KNATIVE_SERVICE_TEMPLATE = void 0;
var FetchConstants_1 = require("../../fetch/FetchConstants");
var ResourceFetch_1 = require("../../fetch/ResourceFetch");
var api_1 = require("../openshift/api");
var common_1 = require("../common");
var Service_1 = require("@kubernetes-models/knative/serving.knative.dev/v1/Service");
var KNATIVE_SERVICE_TEMPLATE = function (args) {
    var _a;
    var imageStreamTrigger = {
        from: {
            name: "".concat(args.resourceName, ":").concat(common_1.BUILD_IMAGE_TAG_VERSION),
            namespace: args.namespace,
            kind: "ImageStreamTag",
        },
        pause: false,
        fieldPath: "spec.template.spec.containers[?(@.name==\"".concat(args.resourceName, "\")].image"),
    };
    var annotations = (_a = {},
        _a[api_1.OpenShiftLabelNames.TRIGGERS] = JSON.stringify([imageStreamTrigger]),
        _a[common_1.ResourceLabelNames.URI] = args.uri,
        _a[common_1.ResourceLabelNames.WORKSPACE_NAME] = args.workspaceName,
        _a);
    return new Service_1.Service({
        metadata: {
            name: args.resourceName,
            namespace: args.namespace,
            labels: __assign(__assign({}, (0, common_1.commonLabels)(__assign({}, args))), (0, common_1.runtimeLabels)()),
            annotations: annotations,
        },
        spec: {
            template: {
                spec: {
                    containers: [
                        {
                            name: args.resourceName,
                            image: "image-registry.openshift-image-registry.svc:5000/".concat(args.namespace, "/").concat(args.resourceName, ":").concat(common_1.BUILD_IMAGE_TAG_VERSION),
                        },
                    ],
                },
            },
        },
    }).toJSON();
};
exports.KNATIVE_SERVICE_TEMPLATE = KNATIVE_SERVICE_TEMPLATE;
var CreateKnativeService = (function (_super) {
    __extends(CreateKnativeService, _super);
    function CreateKnativeService(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    CreateKnativeService.prototype.method = function () {
        return FetchConstants_1.HttpMethod.POST;
    };
    CreateKnativeService.prototype.body = function () {
        return JSON.stringify(this.args.resourceDataSource === common_1.ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : (0, exports.KNATIVE_SERVICE_TEMPLATE)(__assign({}, this.args)));
    };
    CreateKnativeService.prototype.endpoint = function () {
        return "/apis/".concat(Service_1.Service.apiVersion, "/namespaces/").concat(this.args.namespace, "/services");
    };
    return CreateKnativeService;
}(ResourceFetch_1.ResourceFetch));
exports.CreateKnativeService = CreateKnativeService;
var ListKnativeServices = (function (_super) {
    __extends(ListKnativeServices, _super);
    function ListKnativeServices(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    ListKnativeServices.prototype.method = function () {
        return FetchConstants_1.HttpMethod.GET;
    };
    ListKnativeServices.prototype.endpoint = function () {
        var selector = this.args.labelSelector ? "?labelSelector=".concat(this.args.labelSelector) : "";
        return "/apis/".concat(Service_1.Service.apiVersion, "/namespaces/").concat(this.args.namespace, "/services").concat(selector);
    };
    return ListKnativeServices;
}(ResourceFetch_1.ResourceFetch));
exports.ListKnativeServices = ListKnativeServices;
var DeleteKnativeService = (function (_super) {
    __extends(DeleteKnativeService, _super);
    function DeleteKnativeService(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    DeleteKnativeService.prototype.method = function () {
        return FetchConstants_1.HttpMethod.DELETE;
    };
    DeleteKnativeService.prototype.endpoint = function () {
        return "/apis/".concat(Service_1.Service.apiVersion, "/namespaces/").concat(this.args.namespace, "/services/").concat(this.args.resourceName);
    };
    return DeleteKnativeService;
}(ResourceFetch_1.ResourceFetch));
exports.DeleteKnativeService = DeleteKnativeService;
var GetKnativeService = (function (_super) {
    __extends(GetKnativeService, _super);
    function GetKnativeService(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    GetKnativeService.prototype.method = function () {
        return FetchConstants_1.HttpMethod.GET;
    };
    GetKnativeService.prototype.endpoint = function () {
        return "/apis/".concat(Service_1.Service.apiVersion, "/namespaces/").concat(this.args.namespace, "/services/").concat(this.args.resourceName);
    };
    return GetKnativeService;
}(ResourceFetch_1.ResourceFetch));
exports.GetKnativeService = GetKnativeService;
//# sourceMappingURL=KnativeService.js.map