"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDefinition = exports.createEdge = exports.createNode = void 0;
var StunnerEditorEnvelopeAPI_1 = require("./StunnerEditorEnvelopeAPI");
function createNode(node, mapper) {
    var jsNode = new StunnerEditorEnvelopeAPI_1.Node();
    jsNode.uuid = node.getUUID();
    jsNode.definition = createDefinition(node.getContent().getDefinition(), mapper);
    jsNode.inEdges = node.inConnectors().map(function (edge) { return createEdge(edge, mapper); });
    jsNode.outEdges = node.outConnectors().map(function (edge) { return createEdge(edge, mapper); });
    return jsNode;
}
exports.createNode = createNode;
function createEdge(edge, mapper) {
    var jsEdgr = new StunnerEditorEnvelopeAPI_1.Edge();
    jsEdgr.uuid = edge.getUUID();
    jsEdgr.definition = createDefinition(edge.getContent().getDefinition(), mapper);
    jsEdgr.source = edge.getSourceNode().getUUID();
    jsEdgr.target = edge.getTargetNode().getUUID();
    return jsEdgr;
}
exports.createEdge = createEdge;
function createDefinition(bean, mapper) {
    var result = new StunnerEditorEnvelopeAPI_1.Definition();
    result.id = mapper.getId(bean);
    result.name = mapper.getName(bean);
    return result;
}
exports.createDefinition = createDefinition;
//# sourceMappingURL=StunnerEditorEnvelopeAPIFactory.js.map