"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findNodesAtLocation = void 0;
function findNodesAtLocation(_a) {
    var e_1, _b;
    var root = _a.root, path = _a.path, _c = _a.includeUncompleteProps, includeUncompleteProps = _c === void 0 ? false : _c;
    if (!root) {
        return [];
    }
    var nodes = [root];
    var _loop_1 = function (segment) {
        if (segment === "*") {
            nodes = nodes.flatMap(function (s) { var _a; return (_a = s.children) !== null && _a !== void 0 ? _a : []; });
            return "continue";
        }
        if (typeof segment === "number") {
            var index_1 = segment;
            nodes = nodes.flatMap(function (n) {
                if (n.type !== "array" || index_1 < 0 || !Array.isArray(n.children) || index_1 >= n.children.length) {
                    return [];
                }
                return [n.children[index_1]];
            });
        }
        if (typeof segment === "string") {
            nodes = nodes.flatMap(function (n) {
                var e_2, _a;
                if (n.type !== "object" || !Array.isArray(n.children)) {
                    return [];
                }
                try {
                    for (var _b = (e_2 = void 0, __values(n.children)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var prop = _c.value;
                        if (Array.isArray(prop.children) && prop.children[0].value === segment) {
                            if (prop.children.length === 2) {
                                return [prop.children[1]];
                            }
                            if (includeUncompleteProps) {
                                return [prop];
                            }
                        }
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
                return [];
            });
        }
    };
    try {
        for (var path_1 = __values(path), path_1_1 = path_1.next(); !path_1_1.done; path_1_1 = path_1.next()) {
            var segment = path_1_1.value;
            _loop_1(segment);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (path_1_1 && !path_1_1.done && (_b = path_1.return)) _b.call(path_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return nodes;
}
exports.findNodesAtLocation = findNodesAtLocation;
//# sourceMappingURL=findNodesAtLocation.js.map