"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isOffsetAtLastChild = exports.hasNodeComma = exports.parseJsonContent = exports.EditorJsonCodeCompletionStrategy = exports.EditorJsonLanguageService = void 0;
var jsonc = require("jsonc-parser");
var vscode_json_languageservice_1 = require("vscode-json-languageservice");
var vscode_languageserver_types_1 = require("vscode-languageserver-types");
var EditorJsonLanguageService = (function () {
    function EditorJsonLanguageService(args) {
        this.ls = args.ls;
        this.codeCompletionStrategy = args.codeCompletionStrategy;
    }
    EditorJsonLanguageService.prototype.getCompletionItems = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.ls.getCompletionItems(__assign(__assign({}, args), { rootNode: parseJsonContent(args.content), codeCompletionStrategy: this.codeCompletionStrategy }))];
            });
        });
    };
    EditorJsonLanguageService.prototype.getCodeLenses = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.ls.getCodeLenses(__assign(__assign({}, args), { rootNode: parseJsonContent(args.content), codeCompletionStrategy: this.codeCompletionStrategy }))];
            });
        });
    };
    EditorJsonLanguageService.prototype.getDiagnostics = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.ls.getDiagnostics(__assign(__assign({}, args), { rootNode: parseJsonContent(args.content), getSchemaDiagnostics: args.getSchemaDiagnostics }))];
            });
        });
    };
    EditorJsonLanguageService.prototype.getSchemaDiagnostics = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var jsonLs, jsonDocument;
            var _this = this;
            return __generator(this, function (_a) {
                jsonLs = (0, vscode_json_languageservice_1.getLanguageService)({
                    schemaRequestService: function (uri) { return __awaiter(_this, void 0, void 0, function () {
                        return __generator(this, function (_a) {
                            if (uri === args.jsonSchema.$id) {
                                return [2, JSON.stringify(args.jsonSchema)];
                            }
                            else {
                                throw new Error("Unable to load schema from '".concat(uri, "'"));
                            }
                            return [2];
                        });
                    }); },
                });
                jsonLs.configure({
                    allowComments: false,
                    schemas: [{ fileMatch: args.fileMatch, uri: args.jsonSchema.$id }],
                });
                jsonDocument = jsonLs.parseJSONDocument(args.textDocument);
                return [2, jsonLs.doValidation(args.textDocument, jsonDocument)];
            });
        });
    };
    EditorJsonLanguageService.prototype.dispose = function () {
        return this.ls.dispose();
    };
    return EditorJsonLanguageService;
}());
exports.EditorJsonLanguageService = EditorJsonLanguageService;
var EditorJsonCodeCompletionStrategy = (function () {
    function EditorJsonCodeCompletionStrategy() {
    }
    EditorJsonCodeCompletionStrategy.prototype.translate = function (args) {
        var content = args.document.getText();
        var isContentEmpty = !content.trim();
        var isLastChild = isOffsetAtLastChild(content, args.cursorOffset);
        var hasNodeCommaAlready = !isContentEmpty ? hasNodeComma(content, args.cursorOffset) : false;
        return (JSON.stringify(args.completion, null, 2) + (!isContentEmpty && !isLastChild && !hasNodeCommaAlready ? "," : ""));
    };
    EditorJsonCodeCompletionStrategy.prototype.formatLabel = function (label, completionItemKind) {
        return [vscode_languageserver_types_1.CompletionItemKind.Value, vscode_languageserver_types_1.CompletionItemKind.Function, vscode_languageserver_types_1.CompletionItemKind.Folder].includes(completionItemKind)
            ? "\"".concat(label, "\"")
            : label;
    };
    EditorJsonCodeCompletionStrategy.prototype.getStartNodeValuePosition = function (document, node) {
        var position = document.positionAt(node.offset);
        var nextPosition = document.positionAt(node.offset + 1);
        return node.type === "boolean" ? position : nextPosition;
    };
    EditorJsonCodeCompletionStrategy.prototype.shouldComplete = function (args) {
        var cursorJsonLocation = jsonc.getLocation(args.content, args.cursorOffset);
        return cursorJsonLocation.matches(args.path) && cursorJsonLocation.path.length === args.path.length;
    };
    EditorJsonCodeCompletionStrategy.prototype.shouldCreateCodelens = function (_args) {
        return true;
    };
    return EditorJsonCodeCompletionStrategy;
}());
exports.EditorJsonCodeCompletionStrategy = EditorJsonCodeCompletionStrategy;
function parseJsonContent(content) {
    return jsonc.parseTree(content);
}
exports.parseJsonContent = parseJsonContent;
function hasNodeComma(content, cursorOffset) {
    return /^"?[\s\n]*,/.test(content.slice(cursorOffset));
}
exports.hasNodeComma = hasNodeComma;
function isOffsetAtLastChild(content, cursorOffset) {
    if (!content.trim()) {
        return true;
    }
    return /^"?[\s\n]*[\]}]/.test(content.slice(cursorOffset));
}
exports.isOffsetAtLastChild = isOffsetAtLastChild;
//# sourceMappingURL=EditorJsonLanguageService.js.map