"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputReducer = void 0;
var Actions_1 = require("./Actions");
var paths_1 = require("../paths");
var PMMLModelHelper_1 = require("../PMMLModelHelper");
var Outputs_1 = require("../validation/Outputs");
var validation_1 = require("../validation");
var OutputReducer = function (historyService, validationRegistry) {
    return function (state, action) {
        switch (action.type) {
            case Actions_1.Actions.AddOutput:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forOutput().build(), function (draft) {
                    draft.OutputField.push({
                        name: action.payload.outputField.name,
                        dataType: action.payload.outputField.dataType,
                        optype: action.payload.outputField.optype,
                        targetField: action.payload.outputField.targetField,
                        feature: action.payload.outputField.feature,
                        value: action.payload.outputField.value,
                        rank: action.payload.outputField.rank,
                        rankOrder: action.payload.outputField.rankOrder,
                        segmentId: action.payload.outputField.segmentId,
                        isFinalResult: action.payload.outputField.isFinalResult,
                    });
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var outputField = action.payload.outputField;
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex);
                    var outputs = (0, PMMLModelHelper_1.getOutputs)(pmml, modelIndex);
                    if (outputs !== undefined && miningSchema !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forOutput().build());
                        (0, Outputs_1.validateOutputs)(action.payload.modelIndex, outputs.OutputField, miningSchema.MiningField, validationRegistry);
                        if ((0, Outputs_1.isOutputsTargetFieldRequired)(miningSchema.MiningField)) {
                            var outputFieldIndex = outputs.OutputField.length;
                            validationRegistry.set((0, paths_1.Builder)().forModel(modelIndex).forOutput().forOutputField(outputFieldIndex).forTargetField().build(), new validation_1.ValidationEntry(validation_1.ValidationLevel.WARNING, "\"".concat(outputField.name, "\" output field, target field is required if Mining Schema has multiple target fields.")));
                        }
                    }
                });
                break;
            case Actions_1.Actions.DeleteOutput:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forOutput().build(), function (draft) {
                    var outputIndex = action.payload.outputIndex;
                    if (outputIndex >= 0 && outputIndex < draft.OutputField.length) {
                        draft.OutputField.splice(outputIndex, 1);
                    }
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex);
                    var outputs = (0, PMMLModelHelper_1.getOutputs)(pmml, modelIndex);
                    if (miningSchema !== undefined && outputs !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forOutput().build());
                        (0, Outputs_1.validateOutputs)(modelIndex, outputs.OutputField, miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions_1.Actions.AddBatchOutputs:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forOutput().build(), function (draft) {
                    action.payload.outputFields.forEach(function (name) {
                        draft.OutputField.push({
                            name: name,
                            dataType: "string",
                        });
                    });
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex);
                    var outputs = (0, PMMLModelHelper_1.getOutputs)(pmml, modelIndex);
                    if (outputs !== undefined && miningSchema !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forOutput().build());
                        (0, Outputs_1.validateOutputs)(action.payload.modelIndex, outputs.OutputField, miningSchema.MiningField, validationRegistry);
                        if ((0, Outputs_1.isOutputsTargetFieldRequired)(miningSchema.MiningField)) {
                            outputs.OutputField.forEach(function (name, index) {
                                validationRegistry.set((0, paths_1.Builder)()
                                    .forModel(action.payload.modelIndex)
                                    .forOutput()
                                    .forOutputField(index)
                                    .forTargetField()
                                    .build(), new validation_1.ValidationEntry(validation_1.ValidationLevel.WARNING, "\"".concat(name, "\" output field, target field is required if Mining Schema has multiple target fields.")));
                            });
                        }
                    }
                });
                break;
            case Actions_1.Actions.DeleteMiningSchemaField:
                if (state.OutputField.length > 0) {
                    var modelIndex_1 = action.payload.modelIndex;
                    historyService.batch(state, (0, paths_1.Builder)().forModel(modelIndex_1).forOutput().build(), function (draft) {
                        state.OutputField.forEach(function (outputField, outputFieldIndex) {
                            if (outputField.targetField === action.payload.name) {
                                draft.OutputField[outputFieldIndex] = __assign(__assign({}, draft.OutputField[outputFieldIndex]), { targetField: undefined });
                            }
                        });
                    }, function (pmml) {
                        var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex_1);
                        var outputs = (0, PMMLModelHelper_1.getOutputs)(pmml, modelIndex_1);
                        if (miningSchema !== undefined && outputs !== undefined) {
                            validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex_1).forOutput().build());
                            (0, Outputs_1.validateOutputs)(modelIndex_1, outputs.OutputField, miningSchema.MiningField, validationRegistry);
                        }
                    });
                }
                break;
            case Actions_1.Actions.UpdateMiningSchemaField:
                if (state.OutputField.length > 0) {
                    var modelIndex_2 = action.payload.modelIndex;
                    historyService.batch(state, (0, paths_1.Builder)().forModel(modelIndex_2).forOutput().build(), function (draft) {
                        if (action.payload.usageType !== "target") {
                            state.OutputField.forEach(function (outputField, outputFieldIndex) {
                                if (outputField.targetField === action.payload.name) {
                                    draft.OutputField[outputFieldIndex] = __assign(__assign({}, draft.OutputField[outputFieldIndex]), { targetField: undefined });
                                }
                            });
                        }
                    }, function (pmml) {
                        var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex_2);
                        var outputs = (0, PMMLModelHelper_1.getOutputs)(pmml, modelIndex_2);
                        var characteristics = (0, PMMLModelHelper_1.getCharacteristics)(pmml, modelIndex_2);
                        if (miningSchema !== undefined && outputs !== undefined && characteristics !== undefined) {
                            validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex_2).forOutput().build());
                            (0, Outputs_1.validateOutputs)(modelIndex_2, outputs.OutputField, miningSchema.MiningField, validationRegistry);
                        }
                    });
                }
        }
        return state;
    };
};
exports.OutputReducer = OutputReducer;
//# sourceMappingURL=OutputReducer.js.map