"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.PredicateBuilder = exports.Builder = void 0;
var Builders = (function () {
    function Builders(builders) {
        this.builders = builders;
    }
    Builders.prototype.add = function (builder) {
        this.builders.push(builder);
    };
    return Builders;
}());
var BaseBuilder = (function () {
    function BaseBuilder(builders) {
        var clone = [];
        builders.builders.forEach(function (builder) { return clone.push(builder); });
        this.builders = new Builders(clone);
    }
    BaseBuilder.prototype.build = function () {
        var path = this.builders.builders
            .map(function (builder) { return builder.segment(); })
            .filter(function (segment) { return segment !== ""; })
            .join(".");
        return { path: path };
    };
    return BaseBuilder;
}());
var Builder = function () {
    return new PMMLBuilder();
};
exports.Builder = Builder;
var PMMLBuilder = (function (_super) {
    __extends(PMMLBuilder, _super);
    function PMMLBuilder() {
        var _this = _super.call(this, new Builders([])) || this;
        _this.forHeader = function () {
            return new HeaderBuilder(_this.builders);
        };
        _this.forDataDictionary = function () {
            return new DataDictionaryBuilder(_this.builders);
        };
        _this.forModel = function (modelIndex) {
            return new ModelBuilder(_this.builders, modelIndex);
        };
        _this.builders.add(_this);
        return _this;
    }
    PMMLBuilder.prototype.segment = function () {
        return "";
    };
    return PMMLBuilder;
}(BaseBuilder));
var ModelBuilder = (function (_super) {
    __extends(ModelBuilder, _super);
    function ModelBuilder(builders, modelIndex) {
        var _this = _super.call(this, builders) || this;
        _this.forBaselineScore = function () {
            return new BaselineScoreBuilder(_this.builders);
        };
        _this.forUseReasonCodes = function () {
            return new UseReasonCodesBuilder(_this.builders);
        };
        _this.forCharacteristics = function () {
            return new CharacteristicsBuilder(_this.builders);
        };
        _this.forMiningSchema = function () {
            return new MiningSchemaBuilder(_this.builders);
        };
        _this.forOutput = function () {
            return new OutputBuilder(_this.builders);
        };
        _this.builders.add(_this);
        _this.modelIndex = modelIndex;
        return _this;
    }
    ModelBuilder.prototype.segment = function () {
        return this.modelIndex !== undefined ? "models[".concat(this.modelIndex, "]") : "models";
    };
    return ModelBuilder;
}(BaseBuilder));
var HeaderBuilder = (function (_super) {
    __extends(HeaderBuilder, _super);
    function HeaderBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    HeaderBuilder.prototype.segment = function () {
        return "Header";
    };
    return HeaderBuilder;
}(BaseBuilder));
var DataDictionaryBuilder = (function (_super) {
    __extends(DataDictionaryBuilder, _super);
    function DataDictionaryBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.forDataField = function (dataFieldIndex) {
            return new DataFieldBuilder(_this.builders, dataFieldIndex);
        };
        _this.builders.add(_this);
        return _this;
    }
    DataDictionaryBuilder.prototype.segment = function () {
        return "DataDictionary";
    };
    return DataDictionaryBuilder;
}(BaseBuilder));
var DataFieldBuilder = (function (_super) {
    __extends(DataFieldBuilder, _super);
    function DataFieldBuilder(builders, dataFieldIndex) {
        var _this = _super.call(this, builders) || this;
        _this.forInterval = function (intervalIndex) {
            return new IntervalBuilder(_this.builders, intervalIndex);
        };
        _this.forValue = function (valueIndex) {
            return new ValueBuilder(_this.builders, valueIndex);
        };
        _this.builders.add(_this);
        _this.dataFieldIndex = dataFieldIndex;
        return _this;
    }
    DataFieldBuilder.prototype.segment = function () {
        return this.dataFieldIndex !== undefined ? "DataField[".concat(this.dataFieldIndex, "]") : "DataField";
    };
    return DataFieldBuilder;
}(BaseBuilder));
var IntervalBuilder = (function (_super) {
    __extends(IntervalBuilder, _super);
    function IntervalBuilder(builders, intervalIndex) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        _this.intervalIndex = intervalIndex;
        return _this;
    }
    IntervalBuilder.prototype.segment = function () {
        return this.intervalIndex !== undefined ? "Interval[".concat(this.intervalIndex, "]") : "Interval";
    };
    return IntervalBuilder;
}(BaseBuilder));
var ValueBuilder = (function (_super) {
    __extends(ValueBuilder, _super);
    function ValueBuilder(builders, valueIndex) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        _this.valueIndex = valueIndex;
        return _this;
    }
    ValueBuilder.prototype.segment = function () {
        return this.valueIndex !== undefined ? "Value[".concat(this.valueIndex, "]") : "Value";
    };
    return ValueBuilder;
}(BaseBuilder));
var CharacteristicsBuilder = (function (_super) {
    __extends(CharacteristicsBuilder, _super);
    function CharacteristicsBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.forCharacteristic = function (characteristicIndex) {
            return new CharacteristicBuilder(_this.builders, characteristicIndex);
        };
        _this.builders.add(_this);
        return _this;
    }
    CharacteristicsBuilder.prototype.segment = function () {
        return "Characteristics";
    };
    return CharacteristicsBuilder;
}(BaseBuilder));
var CharacteristicBuilder = (function (_super) {
    __extends(CharacteristicBuilder, _super);
    function CharacteristicBuilder(builders, characteristicIndex) {
        var _this = _super.call(this, builders) || this;
        _this.forReasonCode = function () {
            return new ReasonCodeBuilder(_this.builders);
        };
        _this.forBaselineScore = function () {
            return new BaselineScoreBuilder(_this.builders);
        };
        _this.forAttribute = function (attributeIndex) {
            return new AttributeBuilder(_this.builders, attributeIndex);
        };
        _this.builders.add(_this);
        _this.characteristicIndex = characteristicIndex;
        return _this;
    }
    CharacteristicBuilder.prototype.segment = function () {
        return this.characteristicIndex !== undefined ? "Characteristic[".concat(this.characteristicIndex, "]") : "Characteristic";
    };
    return CharacteristicBuilder;
}(BaseBuilder));
var ReasonCodeBuilder = (function (_super) {
    __extends(ReasonCodeBuilder, _super);
    function ReasonCodeBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    ReasonCodeBuilder.prototype.segment = function () {
        return "reasonCode";
    };
    return ReasonCodeBuilder;
}(BaseBuilder));
var BaselineScoreBuilder = (function (_super) {
    __extends(BaselineScoreBuilder, _super);
    function BaselineScoreBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    BaselineScoreBuilder.prototype.segment = function () {
        return "baselineScore";
    };
    return BaselineScoreBuilder;
}(BaseBuilder));
var UseReasonCodesBuilder = (function (_super) {
    __extends(UseReasonCodesBuilder, _super);
    function UseReasonCodesBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    UseReasonCodesBuilder.prototype.segment = function () {
        return "useReasonCodes";
    };
    return UseReasonCodesBuilder;
}(BaseBuilder));
var AttributeBuilder = (function (_super) {
    __extends(AttributeBuilder, _super);
    function AttributeBuilder(builders, attributeIndex) {
        var _this = _super.call(this, builders) || this;
        _this.forPredicate = function (predicateIndex) {
            return new PredicateBuilder(_this.builders, predicateIndex);
        };
        _this.forReasonCode = function () {
            return new ReasonCodeBuilder(_this.builders);
        };
        _this.forPartialScore = function () {
            return new PartialScoreBuilder(_this.builders);
        };
        _this.builders.add(_this);
        _this.attributeIndex = attributeIndex;
        return _this;
    }
    AttributeBuilder.prototype.segment = function () {
        return this.attributeIndex !== undefined ? "Attribute[".concat(this.attributeIndex, "]") : "Attribute";
    };
    return AttributeBuilder;
}(BaseBuilder));
var PartialScoreBuilder = (function (_super) {
    __extends(PartialScoreBuilder, _super);
    function PartialScoreBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    PartialScoreBuilder.prototype.segment = function () {
        return "partialScore";
    };
    return PartialScoreBuilder;
}(BaseBuilder));
var PredicateBuilder = (function (_super) {
    __extends(PredicateBuilder, _super);
    function PredicateBuilder(builders, predicateIndex) {
        var _this = _super.call(this, builders) || this;
        _this.forFieldName = function () {
            return new FieldNameBuilder(_this.builders);
        };
        _this.forPredicate = function (predicateIndex) {
            return new PredicateBuilder(_this.builders, predicateIndex);
        };
        _this.builders.add(_this);
        _this.predicateIndex = predicateIndex;
        return _this;
    }
    PredicateBuilder.prototype.segment = function () {
        return this.predicateIndex !== undefined ? "predicates[".concat(this.predicateIndex, "]") : "predicate";
    };
    return PredicateBuilder;
}(BaseBuilder));
exports.PredicateBuilder = PredicateBuilder;
var FieldNameBuilder = (function (_super) {
    __extends(FieldNameBuilder, _super);
    function FieldNameBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    FieldNameBuilder.prototype.segment = function () {
        return "fieldName";
    };
    return FieldNameBuilder;
}(BaseBuilder));
var MiningSchemaBuilder = (function (_super) {
    __extends(MiningSchemaBuilder, _super);
    function MiningSchemaBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.forMiningField = function (miningFieldIndex) {
            return new MiningFieldBuilder(_this.builders, miningFieldIndex);
        };
        _this.builders.add(_this);
        return _this;
    }
    MiningSchemaBuilder.prototype.segment = function () {
        return "MiningSchema";
    };
    return MiningSchemaBuilder;
}(BaseBuilder));
var MiningFieldBuilder = (function (_super) {
    __extends(MiningFieldBuilder, _super);
    function MiningFieldBuilder(builders, miningFieldIndex) {
        var _this = _super.call(this, builders) || this;
        _this.forImportance = function () {
            return new MiningFieldImportanceBuilder(_this.builders);
        };
        _this.forLowValue = function () {
            return new MiningFieldLowValueBuilder(_this.builders);
        };
        _this.forHighValue = function () {
            return new MiningFieldHighValueBuilder(_this.builders);
        };
        _this.forMissingValueReplacement = function () {
            return new MiningFieldMissingValueReplacementBuilder(_this.builders);
        };
        _this.forInvalidValueReplacement = function () {
            return new MiningFieldInvalidValueReplacementBuilder(_this.builders);
        };
        _this.forDataFieldMissing = function () {
            return new MiningFieldDataFieldMissingBuilder(_this.builders);
        };
        _this.builders.add(_this);
        _this.miningFieldIndex = miningFieldIndex;
        return _this;
    }
    MiningFieldBuilder.prototype.segment = function () {
        return this.miningFieldIndex !== undefined ? "MiningField[".concat(this.miningFieldIndex, "]") : "MiningField";
    };
    return MiningFieldBuilder;
}(BaseBuilder));
var MiningFieldImportanceBuilder = (function (_super) {
    __extends(MiningFieldImportanceBuilder, _super);
    function MiningFieldImportanceBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    MiningFieldImportanceBuilder.prototype.segment = function () {
        return "importance";
    };
    return MiningFieldImportanceBuilder;
}(BaseBuilder));
var MiningFieldLowValueBuilder = (function (_super) {
    __extends(MiningFieldLowValueBuilder, _super);
    function MiningFieldLowValueBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    MiningFieldLowValueBuilder.prototype.segment = function () {
        return "lowValue";
    };
    return MiningFieldLowValueBuilder;
}(BaseBuilder));
var MiningFieldHighValueBuilder = (function (_super) {
    __extends(MiningFieldHighValueBuilder, _super);
    function MiningFieldHighValueBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    MiningFieldHighValueBuilder.prototype.segment = function () {
        return "highValue";
    };
    return MiningFieldHighValueBuilder;
}(BaseBuilder));
var MiningFieldMissingValueReplacementBuilder = (function (_super) {
    __extends(MiningFieldMissingValueReplacementBuilder, _super);
    function MiningFieldMissingValueReplacementBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    MiningFieldMissingValueReplacementBuilder.prototype.segment = function () {
        return "missingValueReplacement";
    };
    return MiningFieldMissingValueReplacementBuilder;
}(BaseBuilder));
var MiningFieldInvalidValueReplacementBuilder = (function (_super) {
    __extends(MiningFieldInvalidValueReplacementBuilder, _super);
    function MiningFieldInvalidValueReplacementBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    MiningFieldInvalidValueReplacementBuilder.prototype.segment = function () {
        return "invalidValueReplacement";
    };
    return MiningFieldInvalidValueReplacementBuilder;
}(BaseBuilder));
var MiningFieldDataFieldMissingBuilder = (function (_super) {
    __extends(MiningFieldDataFieldMissingBuilder, _super);
    function MiningFieldDataFieldMissingBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    MiningFieldDataFieldMissingBuilder.prototype.segment = function () {
        return "dataFieldMissing";
    };
    return MiningFieldDataFieldMissingBuilder;
}(BaseBuilder));
var OutputBuilder = (function (_super) {
    __extends(OutputBuilder, _super);
    function OutputBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.forOutputField = function (outputFieldIndex) {
            return new OutputFieldBuilder(_this.builders, outputFieldIndex);
        };
        _this.builders.add(_this);
        return _this;
    }
    OutputBuilder.prototype.segment = function () {
        return "Output";
    };
    return OutputBuilder;
}(BaseBuilder));
var OutputFieldBuilder = (function (_super) {
    __extends(OutputFieldBuilder, _super);
    function OutputFieldBuilder(builders, outputFieldIndex) {
        var _this = _super.call(this, builders) || this;
        _this.forTargetField = function () {
            return new OutputFieldTargetFieldBuilder(_this.builders);
        };
        _this.builders.add(_this);
        _this.outputFieldIndex = outputFieldIndex;
        return _this;
    }
    OutputFieldBuilder.prototype.segment = function () {
        return this.outputFieldIndex !== undefined ? "OutputField[".concat(this.outputFieldIndex, "]") : "OutputField";
    };
    return OutputFieldBuilder;
}(BaseBuilder));
var OutputFieldTargetFieldBuilder = (function (_super) {
    __extends(OutputFieldTargetFieldBuilder, _super);
    function OutputFieldTargetFieldBuilder(builders) {
        var _this = _super.call(this, builders) || this;
        _this.builders.add(_this);
        return _this;
    }
    OutputFieldTargetFieldBuilder.prototype.segment = function () {
        return "targetField";
    };
    return OutputFieldTargetFieldBuilder;
}(BaseBuilder));
//# sourceMappingURL=PathBuilders.js.map