"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttributesTable = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var molecules_1 = require("../molecules");
require("./AttributesTable.scss");
var Operation_1 = require("../Operation");
var react_redux_1 = require("react-redux");
var OperationContext_1 = require("../OperationContext");
var AttributesTable = function (props) {
    var modelIndex = props.modelIndex, characteristicIndex = props.characteristicIndex, characteristic = props.characteristic, areReasonCodesUsed = props.areReasonCodesUsed, viewAttribute = props.viewAttribute, deleteAttribute = props.deleteAttribute, onCommit = props.onCommit;
    var setActiveOperation = (0, OperationContext_1.useOperation)().setActiveOperation;
    var _a = __read((0, react_1.useState)(undefined), 2), attributeFocusIndex = _a[0], setAttributeFocusIndex = _a[1];
    var dataFields = (0, react_redux_1.useSelector)(function (state) {
        return state.DataDictionary.DataField;
    });
    var miningFields = (0, react_redux_1.useSelector)(function (state) {
        var _model = state.models ? state.models[props.modelIndex] : undefined;
        if (_model && _model instanceof pmml_editor_marshaller_1.Scorecard) {
            return _model.MiningSchema.MiningField;
        }
        return [];
    });
    (0, react_1.useEffect)(function () {
        var _a;
        if (attributeFocusIndex !== undefined) {
            (_a = document.querySelector("#attribute-n".concat(attributeFocusIndex))) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [characteristic.Attribute, attributeFocusIndex]);
    var onEdit = function (index) {
        setActiveOperation(Operation_1.Operation.UPDATE_ATTRIBUTE);
        viewAttribute(index);
    };
    var handleDelete = function (index, interaction) {
        var _a;
        onDelete(index);
        if (interaction === "mouse") {
            if (document.activeElement instanceof HTMLElement) {
                (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur();
            }
        }
        else if (interaction === "keyboard") {
            setAttributeFocusIndex(index);
        }
    };
    var onDelete = function (index) {
        if (index !== undefined) {
            deleteAttribute(index);
        }
    };
    return ((0, jsx_runtime_1.jsx)("section", __assign({ "data-testid": "attributes-table" }, { children: characteristic.Attribute.map(function (attribute, index) {
            return ((0, jsx_runtime_1.jsx)("article", __assign({ className: "editable-item attribute-item-n".concat(index) }, { children: (0, jsx_runtime_1.jsx)(molecules_1.AttributesTableRow, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, characteristic: characteristic, attributeIndex: index, attribute: attribute, areReasonCodesUsed: areReasonCodesUsed, characteristicReasonCode: characteristic.reasonCode, dataFields: dataFields, miningFields: miningFields, onEdit: function () { return onEdit(index); }, onDelete: function (interaction) { return handleDelete(index, interaction); }, onCommit: function (partial) { return onCommit(index, partial); } }, index) }), index));
        }) })));
};
exports.AttributesTable = AttributesTable;
//# sourceMappingURL=AttributesTable.js.map