"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstraintType = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var react_transition_group_1 = require("react-transition-group");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Flex_1 = require("@patternfly/react-core/dist/js/layouts/Flex");
var Bullseye_1 = require("@patternfly/react-core/dist/js/layouts/Bullseye");
var Alert_1 = require("@patternfly/react-core/dist/js/components/Alert");
var sort_icon_1 = require("@patternfly/react-icons/dist/js/icons/sort-icon");
var plus_icon_1 = require("@patternfly/react-icons/dist/js/icons/plus-icon");
var bolt_icon_1 = require("@patternfly/react-icons/dist/js/icons/bolt-icon");
var DataTypeItem_1 = require("../DataTypeItem/DataTypeItem");
var MultipleDataTypeAdd_1 = require("../MultipleDataTypeAdd/MultipleDataTypeAdd");
var DataTypesSort_1 = require("../DataTypesSort/DataTypesSort");
var EmptyDataDictionary_1 = require("../EmptyDataDictionary/EmptyDataDictionary");
var PMMLModelHelper_1 = require("../../../PMMLModelHelper");
require("./DataDictionaryContainer.scss");
var DataDictionaryPropertiesEdit_1 = require("../DataDictionaryPropertiesEdit/DataDictionaryPropertiesEdit");
var lodash_1 = require("lodash");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var DataDictionaryContainer = function (props) {
    var dataDictionary = props.dataDictionary, onAdd = props.onAdd, onEdit = props.onEdit, onDelete = props.onDelete, onReorder = props.onReorder, onBatchAdd = props.onBatchAdd, onEditingPhaseChange = props.onEditingPhaseChange;
    var _a = __read((0, react_1.useState)(dataDictionary), 2), dataTypes = _a[0], setDataTypes = _a[1];
    var _b = __read((0, react_1.useState)(), 2), editing = _b[0], setEditing = _b[1];
    var _c = __read((0, react_1.useState)("main"), 2), viewSection = _c[0], setViewSection = _c[1];
    var _d = __read((0, react_1.useState)(), 2), editingDataType = _d[0], setEditingDataType = _d[1];
    var _e = __read((0, react_1.useState)(false), 2), sorting = _e[0], setSorting = _e[1];
    var _f = __read((0, react_1.useState)(undefined), 2), dataTypeFocusIndex = _f[0], setDataTypeFocusIndex = _f[1];
    (0, react_1.useEffect)(function () {
        if (editing === dataDictionary.length) {
            setEditing(undefined);
            if (viewSection !== "main") {
                setViewSection("main");
            }
            onEditingPhaseChange(false);
        }
        if (viewSection === "properties" && editing !== undefined) {
            setEditingDataType(dataDictionary[editing]);
        }
        setDataTypes(dataDictionary);
    }, [dataDictionary, editing, viewSection]);
    var handleOutsideClick = function () {
        setEditing(undefined);
        onEditingPhaseChange(false);
    };
    var addDataType = function () {
        onAdd((0, PMMLModelHelper_1.findIncrementalName)("New Data Type", dataTypes.map(function (dt) { return dt.name; }), 1), "string", "categorical");
        setEditing(dataTypes.length);
        onEditingPhaseChange(true);
    };
    var saveDataType = function (dataType, index) {
        onEdit(index, dataTypes[index].name, dataType);
    };
    var handleSave = function (dataType, index) {
        saveDataType(dataType, index);
    };
    var handleDelete = function (index, interaction) {
        var _a;
        onDelete(index);
        if (interaction === "mouse") {
            if (document.activeElement instanceof HTMLElement) {
                (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur();
            }
        }
        else if (interaction === "keyboard") {
            setDataTypeFocusIndex(index);
        }
        setEditing(undefined);
        onEditingPhaseChange(false);
    };
    var handleEdit = function (index) {
        setEditing(index);
        onEditingPhaseChange(true);
    };
    var handleMultipleAdd = function (fields) {
        var fieldsNames = fields.split("\n").filter(function (item) { return item.trim().length > 0; });
        onBatchAdd(fieldsNames);
        setViewSection("main");
    };
    var handleConstraintsEdit = function (dataType) {
        if (editing !== undefined) {
            setEditingDataType(dataType);
            setViewSection("properties");
            onEditingPhaseChange(true);
        }
    };
    var handleConstraintsSave = function (payload) {
        if (editing !== undefined) {
            onEdit(editing, dataTypes[editing].name, payload);
        }
    };
    var handlePropertiesSave = function (payload) {
        if (editing !== undefined) {
            var dataType_1 = dataTypes[editing];
            var existingPartial_1 = {};
            Object.keys(payload).forEach(function (key) { return Reflect.set(existingPartial_1, key, Reflect.get(dataType_1, key)); });
            if (!(0, lodash_1.isEqual)(payload, existingPartial_1)) {
                onEdit(editing, dataType_1.name, Object.assign(dataType_1, payload));
            }
        }
    };
    var exitFromPropertiesEdit = function () {
        setViewSection("main");
    };
    var toggleSorting = function () {
        setEditing(undefined);
        setSorting(!sorting);
    };
    var dataTypeNameValidation = function (dataTypeName) {
        var isValid = true;
        if (dataTypeName.trim().length === 0) {
            return false;
        }
        var match = dataTypes.find(function (item, index) { return item.name === dataTypeName.trim() && index !== editing; });
        if (match !== undefined) {
            isValid = false;
        }
        return isValid;
    };
    var getTransition = function (currentState) {
        if (currentState === "main") {
            return "data-dictionary__overview";
        }
        else if (currentState === "batch-add") {
            return "enter-from-above";
        }
        else {
            return "enter-from-right";
        }
    };
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useRef)(validationRegistry.get((0, paths_1.Builder)().forDataDictionary().build()));
    (0, react_1.useEffect)(function () {
        if (editing === undefined) {
            validations.current = validationRegistry.get((0, paths_1.Builder)().forDataDictionary().build());
        }
    }, [dataDictionary, editing]);
    (0, react_1.useEffect)(function () {
        var _a;
        if (dataTypeFocusIndex !== undefined) {
            (_a = document.querySelector("#data-type-item-n".concat(dataTypeFocusIndex))) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [dataDictionary, dataTypeFocusIndex]);
    return ((0, jsx_runtime_1.jsx)("div", __assign({ className: "data-dictionary", "data-testid": "data-dictionary-container" }, { children: (0, jsx_runtime_1.jsx)(react_transition_group_1.SwitchTransition, __assign({ mode: "out-in" }, { children: (0, jsx_runtime_1.jsx)(react_transition_group_1.CSSTransition, __assign({ timeout: {
                    enter: 230,
                    exit: 100,
                }, classNames: getTransition(viewSection) }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [viewSection === "main" && ((0, jsx_runtime_1.jsxs)("section", __assign({ className: "data-dictionary__overview" }, { children: [(0, jsx_runtime_1.jsxs)(Flex_1.Flex, __assign({ className: "data-dictionary__toolbar", "data-ouia-component-id": "dd-toolbar" }, { children: [(0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "primary", onClick: function (event) {
                                                    event.stopPropagation();
                                                    event.preventDefault();
                                                    addDataType();
                                                }, icon: (0, jsx_runtime_1.jsx)(plus_icon_1.PlusIcon, {}), iconPosition: "left", isDisabled: editing !== undefined || sorting, ouiaId: "add-data-type" }, { children: "Add Data Type" })) }), (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "secondary", onClick: function () { return setViewSection("batch-add"); }, icon: (0, jsx_runtime_1.jsx)(bolt_icon_1.BoltIcon, {}), iconPosition: "left", isDisabled: editing !== undefined || sorting, ouiaId: "add-multiple-data-type" }, { children: "Add Multiple Data Types" })) }), (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, __assign({ align: { default: "alignRight" } }, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: sorting ? "primary" : "secondary", onClick: toggleSorting, icon: (0, jsx_runtime_1.jsx)(sort_icon_1.SortIcon, {}), iconPosition: "left", isDisabled: editing !== undefined, ouiaId: "order-toggle" }, { children: sorting ? "End Ordering" : "Order" })) }))] })), !sorting && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [validations.current && validations.current.length > 0 && ((0, jsx_runtime_1.jsx)("section", __assign({ className: "data-dictionary__validation-alert" }, { children: (0, jsx_runtime_1.jsx)(Alert_1.Alert, { variant: "warning", isInline: true, title: "Some items are invalid and need attention." }) }))), (0, jsx_runtime_1.jsxs)("section", __assign({ className: "data-dictionary__types-list", "data-ouia-component-id": "dd-types-list" }, { children: [dataTypes.length === 0 && ((0, jsx_runtime_1.jsx)(Bullseye_1.Bullseye, __assign({ style: { height: "40vh" } }, { children: (0, jsx_runtime_1.jsx)(EmptyDataDictionary_1.default, {}) }))), dataTypes.map(function (item, index) { return ((0, jsx_runtime_1.jsx)(DataTypeItem_1.default, { dataType: item, editingIndex: editing, index: index, onSave: handleSave, onEdit: handleEdit, onDelete: handleDelete, onConstraintsEdit: handleConstraintsEdit, onConstraintsSave: handleConstraintsSave, onValidate: dataTypeNameValidation, onOutsideClick: handleOutsideClick }, index)); })] }))] })), sorting && ((0, jsx_runtime_1.jsx)("section", __assign({ className: "data-dictionary__types-list" }, { children: (0, jsx_runtime_1.jsx)(DataTypesSort_1.default, { dataTypes: dataTypes, onReorder: onReorder }) })))] }))), viewSection === "batch-add" && ((0, jsx_runtime_1.jsx)(MultipleDataTypeAdd_1.default, { onAdd: handleMultipleAdd, onCancel: function () { return setViewSection("main"); } })), viewSection === "properties" && ((0, jsx_runtime_1.jsx)(DataDictionaryPropertiesEdit_1.default, { dataType: editingDataType, dataFieldIndex: editing, onClose: exitFromPropertiesEdit, onSave: handlePropertiesSave }))] }) }), viewSection) })) })));
};
exports.default = DataDictionaryContainer;
var ConstraintType;
(function (ConstraintType) {
    ConstraintType["RANGE"] = "Range";
    ConstraintType["ENUMERATION"] = "Enumeration";
    ConstraintType["NONE"] = "";
})(ConstraintType = exports.ConstraintType || (exports.ConstraintType = {}));
//# sourceMappingURL=DataDictionaryContainer.js.map