import * as React from "react";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { ExclamationTriangleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { I18nWrapped } from "@kie-tools-core/i18n/dist/react-components";
import { CubesIcon } from "@patternfly/react-icons/dist/js/icons/cubes-icon";
import { ExclamationIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-icon";
const ISSUES_URL = "https://github.com/apache/incubator-kie-issues/issues";
export var FormStatus;
(function (FormStatus) {
    FormStatus[FormStatus["WITHOUT_ERROR"] = 0] = "WITHOUT_ERROR";
    FormStatus[FormStatus["VALIDATOR_ERROR"] = 1] = "VALIDATOR_ERROR";
    FormStatus[FormStatus["AUTO_GENERATION_ERROR"] = 2] = "AUTO_GENERATION_ERROR";
    FormStatus[FormStatus["EMPTY"] = 3] = "EMPTY";
})(FormStatus || (FormStatus = {}));
export function EmptyFormStatus({ i18n }) {
    return (React.createElement("div", null,
        React.createElement(EmptyState, null,
            React.createElement(EmptyStateIcon, { icon: CubesIcon }),
            React.createElement(TextContent, null,
                React.createElement(Text, { component: "h2" }, i18n.form.status.emptyForm.title)),
            React.createElement(EmptyStateBody, null,
                React.createElement(TextContent, null,
                    React.createElement(Text, { component: TextVariants.p }, i18n.form.status.emptyForm.explanation))))));
}
export function AutoGenerationErrorFormStatus(props) {
    return (React.createElement("div", null,
        React.createElement(EmptyState, null,
            React.createElement(EmptyStateIcon, { icon: ExclamationIcon }),
            React.createElement(TextContent, null,
                React.createElement(Text, { component: "h2" }, props.i18n.form.status.autoGenerationError.title)),
            React.createElement(EmptyStateBody, null,
                React.createElement(TextContent, null, props.i18n.form.status.autoGenerationError.explanation),
                React.createElement("br", null),
                props.notificationsPanel && (React.createElement(TextContent, null,
                    React.createElement(I18nWrapped, { components: { link: React.createElement("a", { onClick: props.openValidationTab }, props.i18n.terms.validation) } }, props.i18n.form.status.autoGenerationError.checkNotificationPanel)))))));
}
export function ValidatorErrorFormStatus({ i18n }) {
    return (React.createElement("div", null,
        React.createElement(EmptyState, null,
            React.createElement(EmptyStateIcon, { icon: ExclamationTriangleIcon }),
            React.createElement(TextContent, null,
                React.createElement(Text, { component: "h2" }, i18n.form.status.validatorError.title)),
            React.createElement(EmptyStateBody, null,
                React.createElement(TextContent, null,
                    React.createElement(Text, null,
                        React.createElement(I18nWrapped, { components: {
                                jira: (React.createElement("a", { href: ISSUES_URL, target: "_blank", rel: "noopener noreferrer" }, ISSUES_URL)),
                            } }, i18n.form.status.validatorError.message)))))));
}
//# sourceMappingURL=FormStatus.js.map