import { FormStatus } from "./FormStatus";
import { ErrorBoundary } from "@kie-tools/dmn-runner/dist/ErrorBoundary";
import * as React from "react";
import { FormI18n } from "./i18n";
import { FormJsonSchemaBridge } from "./uniforms/FormJsonSchemaBridge";
export interface FormBaseProps {
    id?: string;
    i18n: FormI18n;
    setFormError: React.Dispatch<React.SetStateAction<boolean>>;
    setFormRef: React.Dispatch<React.SetStateAction<HTMLFormElement | null>>;
    showInlineError?: boolean;
    autoSave?: boolean;
    autoSaveDelay?: number;
    placeholder?: boolean;
    onSubmit?: (model: object) => void;
    onValidate?: (model: object, error: object) => void;
    errorsField?: () => React.ReactNode;
    submitField?: () => React.ReactNode;
    formStatus: FormStatus;
    notificationsPanel: boolean;
    openValidationTab?: () => void;
    errorBoundaryRef: React.RefObject<ErrorBoundary>;
    formModel?: object;
    jsonSchemaBridge?: FormJsonSchemaBridge;
}
export declare function FormBase(props: React.PropsWithChildren<FormBaseProps>): JSX.Element;
//# sourceMappingURL=FormBase.d.ts.map