"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FsUsageCounter = void 0;
var FsUsageCounter = (function () {
    function FsUsageCounter() {
        this.counter = new Map();
    }
    FsUsageCounter.prototype.isInUse = function (fsMountPoint) {
        return this.counter.has(fsMountPoint);
    };
    FsUsageCounter.prototype.addUsage = function (fsMountPoint) {
        var _a;
        console.log("Adding to usage counter ".concat(fsMountPoint));
        this.counter.set(fsMountPoint, ((_a = this.counter.get(fsMountPoint)) !== null && _a !== void 0 ? _a : 0) + 1);
    };
    FsUsageCounter.prototype.releaseUsage = function (fsMountPoint) {
        var currentCount = this.counter.get(fsMountPoint);
        if (!currentCount) {
            throw new Error("Catastrophic error releasing usage of ".concat(fsMountPoint, ". No ack counterpart."));
        }
        console.log("Subtracting from usage counter ".concat(fsMountPoint));
        var nextCount = currentCount - 1;
        if (nextCount < 0) {
            throw new Error("Catastrophic error releasing usage of ".concat(fsMountPoint, ". Negative usage count."));
        }
        else if (nextCount === 0) {
            this.counter.delete(fsMountPoint);
        }
        else {
            this.counter.set(fsMountPoint, nextCount);
        }
        return { usagesLeft: nextCount };
    };
    return FsUsageCounter;
}());
exports.FsUsageCounter = FsUsageCounter;
//# sourceMappingURL=FsUsageCounter.js.map