import { FsCache } from "./FsCache";
import { Subscribable } from "./Subscribable";
export declare enum FlushStateStatus {
    FLUSH_IN_PROGRESS = 0,
    FLUSH_SCHEDULED = 1,
    FLUSH_PAUSED = 2
}
export declare type FlushState = {
    scheduledFlush: ReturnType<typeof setTimeout>;
    status: FlushStateStatus.FLUSH_SCHEDULED;
} | {
    flushPromise: Promise<void>;
    status: FlushStateStatus.FLUSH_IN_PROGRESS;
} | {
    status: FlushStateStatus.FLUSH_PAUSED;
};
export declare class FsFlushManager {
    private readonly stateControl;
    readonly subscribable: Subscribable<string[]>;
    pauseScheduledFlushIfScheduled(fsMountPoint: string): void;
    requestFsFlush(fsCache: FsCache, fsMountPoint: string, debounceArgs: {
        debounceTimeoutInMs: number;
    }): Promise<void>;
    executeFlush(fsCache: FsCache, fsMountPoint: string): Promise<void>;
    private scheduleFsFlush;
    expediteFlush(fsCache: FsCache, fsMountPoint: string, flushArgs: {
        executeEvenIfNotScheduled: boolean;
    }): Promise<void>;
}
//# sourceMappingURL=FsFlushManager.d.ts.map