"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractExtension = exports.parseWorkspaceFileRelativePath = void 0;
var path_1 = require("path");
var ExtensionHelper_1 = require("../constants/ExtensionHelper");
function parseWorkspaceFileRelativePath(relativePath) {
    var extension = extractExtension(relativePath);
    var extensionIndex = relativePath.lastIndexOf("." + extension);
    var name = (0, path_1.basename)(relativePath);
    return {
        relativePathWithoutExtension: extensionIndex !== -1 ? relativePath.substring(0, extensionIndex) : relativePath,
        relativeDirPath: (0, path_1.parse)(relativePath).dir,
        extension: extension,
        nameWithoutExtension: name !== ".".concat(extension) ? (0, path_1.basename)(relativePath, ".".concat(extension)) : "",
        name: name,
    };
}
exports.parseWorkspaceFileRelativePath = parseWorkspaceFileRelativePath;
function extractExtension(relativePath) {
    var fileName = (0, path_1.basename)(relativePath);
    var ultimateExtension = fileName.substring(fileName.lastIndexOf("."));
    var fileWithoutUltimateExtension = fileName.substring(0, fileName.lastIndexOf(ultimateExtension));
    var penultimateExtension = fileWithoutUltimateExtension.substring(fileWithoutUltimateExtension.lastIndexOf("."));
    if (fileName.includes(".")) {
        if ((0, ExtensionHelper_1.isOfKind)("supportedSingleExtensions", fileName)) {
            return ultimateExtension.replace(".", "");
        }
        if ((0, ExtensionHelper_1.isOfKind)("supportedDoubleExtensions", fileName)) {
            return penultimateExtension.replace(".", "") + ultimateExtension;
        }
        else {
            return ultimateExtension.replace(".", "");
        }
    }
    else {
        return (0, path_1.extname)(relativePath);
    }
}
exports.extractExtension = extractExtension;
//# sourceMappingURL=WorkspaceFileRelativePathParser.js.map