"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspacesContextProvider = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var react_2 = require("react");
var WorkspacesContext_1 = require("./WorkspacesContext");
var WorkspacesSharedWorker_1 = require("../worker/WorkspacesSharedWorker");
function WorkspacesContextProvider(props) {
    var _this = this;
    var _a = __read((0, react_1.useState)(new WorkspacesSharedWorker_1.WorkspacesSharedWorker({
        workerName: "".concat(props.workerNamePrefix, "-workspaces-shared-worker"),
        workerScriptUrl: props.workspacesSharedWorkerScriptUrl,
    })), 2), workspacesSharedWorker = _a[0], setWorkspacesSharedWorker = _a[1];
    var updateWorkspaceSharedWorker = (0, react_2.useCallback)(function () {
        setWorkspacesSharedWorker(function (currentWorkspacesSharedWorker) {
            currentWorkspacesSharedWorker.closeWorkerPort();
            return new WorkspacesSharedWorker_1.WorkspacesSharedWorker({
                workerName: "".concat(props.workerNamePrefix, "-workspaces-shared-worker"),
                workerScriptUrl: props.workspacesSharedWorkerScriptUrl,
            });
        });
    }, [props.workerNamePrefix, props.workspacesSharedWorkerScriptUrl]);
    (0, react_1.useEffect)(function () {
        window.addEventListener("resume", updateWorkspaceSharedWorker, { capture: true });
        return function () {
            window.removeEventListener("resume", updateWorkspaceSharedWorker, { capture: true });
        };
    }, [updateWorkspaceSharedWorker]);
    var toWorkspaceFile = (0, react_2.useCallback)(function (wwfd) {
        return new WorkspacesContext_1.WorkspaceFile({
            workspaceId: wwfd.workspaceId,
            relativePath: wwfd.relativePath,
            getFileContents: function () {
                return workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_getFileContent(wwfd);
                });
            },
        });
    }, [workspacesSharedWorker]);
    var hasLocalChanges = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_hasLocalChanges(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var getUnstagedModifiedFilesStatus = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_getUnstagedModifiedFilesStatus(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var pull = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_pull(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var push = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_push(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var deleteBranch = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_deleteBranch(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var addRemote = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_addRemote(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var deleteRemote = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_deleteRemote(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var branch = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_branch(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var fetch = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_fetch(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var checkout = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_checkout(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var checkoutFilesFromLocalHead = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_checkoutFilesFromLocalHead(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var resolveRef = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_resolveRef(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var commit = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_commit(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var createSavePoint = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        var _a, commitMessage_1, e_1;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = !args.forceHasChanges;
                    if (!_a) return [3, 2];
                    return [4, hasLocalChanges(args)];
                case 1:
                    _a = !(_b.sent());
                    _b.label = 2;
                case 2:
                    if (_a) {
                        return [2];
                    }
                    if (!props.shouldRequireCommitMessage) return [3, 7];
                    _b.label = 3;
                case 3:
                    _b.trys.push([3, 5, , 6]);
                    return [4, props.onCommitMessageRequest(args.commitMessage)];
                case 4:
                    commitMessage_1 = _b.sent();
                    return [3, 6];
                case 5:
                    e_1 = _b.sent();
                    throw new Error("No commit message!");
                case 6: return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                        return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_createSavePoint(__assign(__assign({}, args), { commitMessage: commitMessage_1 }));
                    })];
                case 7: return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                        return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_createSavePoint(args);
                    })];
            }
        });
    }); }, [hasLocalChanges, props, workspacesSharedWorker]);
    var stageFile = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_stageFile(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var getGitServerRefs = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_getGitServerRefs(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var getFile = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        var wwfd;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                        return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_getFile(args);
                    })];
                case 1:
                    wwfd = _a.sent();
                    return [2, wwfd ? toWorkspaceFile(wwfd) : undefined];
            }
        });
    }); }, [workspacesSharedWorker, toWorkspaceFile]);
    var createWorkspaceFromLocal = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        var workspaceInit, _a;
        var _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0: return [4, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                        return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_init(args);
                    })];
                case 1:
                    workspaceInit = _c.sent();
                    _b = {
                        workspace: workspaceInit.workspace
                    };
                    if (!workspaceInit.suggestedFirstFile) return [3, 3];
                    return [4, getFile({
                            workspaceId: workspaceInit.suggestedFirstFile.workspaceId,
                            relativePath: workspaceInit.suggestedFirstFile.relativePath,
                        })];
                case 2:
                    _a = _c.sent();
                    return [3, 4];
                case 3:
                    _a = undefined;
                    _c.label = 4;
                case 4: return [2, (_b.suggestedFirstFile = _a,
                        _b)];
            }
        });
    }); }, [getFile, workspacesSharedWorker]);
    var createWorkspaceFromGitRepository = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        var workspaceClone, _a;
        var _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0: return [4, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                        return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_clone(args);
                    })];
                case 1:
                    workspaceClone = _c.sent();
                    _b = {
                        workspace: workspaceClone.workspace
                    };
                    if (!workspaceClone.suggestedFirstFile) return [3, 3];
                    return [4, getFile({
                            workspaceId: workspaceClone.suggestedFirstFile.workspaceId,
                            relativePath: workspaceClone.suggestedFirstFile.relativePath,
                        })];
                case 2:
                    _a = _c.sent();
                    return [3, 4];
                case 3:
                    _a = undefined;
                    _c.label = 4;
                case 4: return [2, (_b.suggestedFirstFile = _a,
                        _b)];
            }
        });
    }); }, [getFile, workspacesSharedWorker]);
    var isFileModified = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_isModified(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var getUniqueFileIdentifier = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_getUniqueFileIdentifier(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var renameFile = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        var wwfd;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                        return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_renameFile({
                            wwfd: {
                                workspaceId: args.file.workspaceId,
                                relativePath: args.file.relativePath,
                            },
                            newFileNameWithoutExtension: args.newFileNameWithoutExtension,
                        });
                    })];
                case 1:
                    wwfd = _a.sent();
                    return [2, toWorkspaceFile(wwfd)];
            }
        });
    }); }, [workspacesSharedWorker, toWorkspaceFile]);
    var getFiles = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        var wwfds;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                        return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_getFiles(args);
                    })];
                case 1:
                    wwfds = _a.sent();
                    return [2, wwfds.map(function (wwfd) { return toWorkspaceFile(wwfd); })];
            }
        });
    }); }, [workspacesSharedWorker, toWorkspaceFile]);
    var getFileContent = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_getFileContent(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var deleteFile = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_deleteFile({
                        wwfd: {
                            workspaceId: args.file.workspaceId,
                            relativePath: args.file.relativePath,
                        },
                    });
                })];
        });
    }); }, [workspacesSharedWorker]);
    var moveFile = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        var wwfd;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                        return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_moveFile({
                            wwfd: {
                                workspaceId: args.file.workspaceId,
                                relativePath: args.file.relativePath,
                            },
                            newDirPath: args.newDirPath,
                        });
                    })];
                case 1:
                    wwfd = _a.sent();
                    return [2, toWorkspaceFile(wwfd)];
            }
        });
    }); }, [toWorkspaceFile, workspacesSharedWorker]);
    var updateFile = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_updateFile({
                        wwfd: {
                            workspaceId: args.workspaceId,
                            relativePath: args.relativePath,
                        },
                        newContent: args.newContent,
                    });
                })];
        });
    }); }, [workspacesSharedWorker]);
    var addFile = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        var wwfd;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                        return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_addFile(args);
                    })];
                case 1:
                    wwfd = _a.sent();
                    return [2, toWorkspaceFile(wwfd)];
            }
        });
    }); }, [workspacesSharedWorker, toWorkspaceFile]);
    var existsFile = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_existsFile(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var addEmptyFile = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        var wwfd;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                        return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_addEmptyFile(args);
                    })];
                case 1:
                    wwfd = _a.sent();
                    return [2, toWorkspaceFile(wwfd)];
            }
        });
    }); }, [workspacesSharedWorker, toWorkspaceFile]);
    var prepareZip = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_prepareZip(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var resourceContentGet = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_resourceContentGet(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var resourceContentList = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_resourceContentList(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var deleteWorkspace = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_deleteWorkspace(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var renameWorkspace = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_renameWorkspace(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var listAllWorkspaces = (0, react_2.useCallback)(function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_listAllWorkspaces();
                })];
        });
    }); }, [workspacesSharedWorker]);
    var getWorkspace = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesStorage_getWorkspace(args);
                })];
        });
    }); }, [workspacesSharedWorker]);
    var initGitOnWorkspace = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_initGitOnExistingWorkspace({
                        workspaceId: args.workspaceId,
                        remoteUrl: args.remoteUrl.toString(),
                        branch: args.branch,
                        insecurelyDisableTlsCertificateValidation: args.insecurelyDisableTlsCertificateValidation,
                    });
                })];
        });
    }); }, [workspacesSharedWorker]);
    var initGistOnWorkspace = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_initGistOnExistingWorkspace({
                        workspaceId: args.workspaceId,
                        remoteUrl: args.remoteUrl.toString(),
                        branch: args.branch,
                        insecurelyDisableTlsCertificateValidation: args.insecurelyDisableTlsCertificateValidation,
                    });
                })];
        });
    }); }, [workspacesSharedWorker]);
    var initSnippetOnWorkspace = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_initSnippetOnExistingWorkspace({
                        workspaceId: args.workspaceId,
                        remoteUrl: args.remoteUrl.toString(),
                        branch: args.branch,
                        insecurelyDisableTlsCertificateValidation: args.insecurelyDisableTlsCertificateValidation,
                    });
                })];
        });
    }); }, [workspacesSharedWorker]);
    var changeGitAuthSessionId = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_changeGitAuthSessionId({
                    workspaceId: args.workspaceId,
                    gitAuthSessionId: args.gitAuthSessionId,
                    insecurelyDisableTlsCertificateValidation: args.insecurelyDisableTlsCertificateValidation,
                });
            });
            return [2];
        });
    }); }, [workspacesSharedWorker]);
    var initLocalOnWorkspace = (0, react_2.useCallback)(function (args) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, workspacesSharedWorker.withBus(function (workspacesWorkerBus) {
                    return workspacesWorkerBus.clientApi.requests.kieSandboxWorkspacesGit_initLocalOnExistingWorkspace({
                        workspaceId: args.workspaceId,
                    });
                })];
        });
    }); }, [workspacesSharedWorker]);
    var value = (0, react_2.useMemo)(function () { return ({
        workspacesSharedWorker: workspacesSharedWorker,
        resourceContentGet: resourceContentGet,
        resourceContentList: resourceContentList,
        createWorkspaceFromLocal: createWorkspaceFromLocal,
        createWorkspaceFromGitRepository: createWorkspaceFromGitRepository,
        renameWorkspace: renameWorkspace,
        deleteWorkspace: deleteWorkspace,
        prepareZip: prepareZip,
        getUniqueFileIdentifier: getUniqueFileIdentifier,
        createSavePoint: createSavePoint,
        stageFile: stageFile,
        commit: commit,
        pull: pull,
        addRemote: addRemote,
        deleteRemote: deleteRemote,
        push: push,
        deleteBranch: deleteBranch,
        branch: branch,
        checkout: checkout,
        checkoutFilesFromLocalHead: checkoutFilesFromLocalHead,
        fetch: fetch,
        resolveRef: resolveRef,
        getFiles: getFiles,
        hasLocalChanges: hasLocalChanges,
        getUnstagedModifiedFilesStatus: getUnstagedModifiedFilesStatus,
        moveFile: moveFile,
        addEmptyFile: addEmptyFile,
        addFile: addFile,
        existsFile: existsFile,
        renameFile: renameFile,
        updateFile: updateFile,
        deleteFile: deleteFile,
        getFile: getFile,
        getFileContent: getFileContent,
        listAllWorkspaces: listAllWorkspaces,
        getWorkspace: getWorkspace,
        initGitOnWorkspace: initGitOnWorkspace,
        initGistOnWorkspace: initGistOnWorkspace,
        initSnippetOnWorkspace: initSnippetOnWorkspace,
        changeGitAuthSessionId: changeGitAuthSessionId,
        initLocalOnWorkspace: initLocalOnWorkspace,
        isFileModified: isFileModified,
        getGitServerRefs: getGitServerRefs,
    }); }, [
        workspacesSharedWorker,
        addEmptyFile,
        addFile,
        existsFile,
        createSavePoint,
        stageFile,
        commit,
        createWorkspaceFromGitRepository,
        createWorkspaceFromLocal,
        deleteFile,
        deleteWorkspace,
        getFileContent,
        getFile,
        getFiles,
        getUniqueFileIdentifier,
        hasLocalChanges,
        getUnstagedModifiedFilesStatus,
        moveFile,
        prepareZip,
        pull,
        addRemote,
        deleteRemote,
        push,
        deleteBranch,
        branch,
        checkout,
        checkoutFilesFromLocalHead,
        fetch,
        resolveRef,
        renameFile,
        renameWorkspace,
        resourceContentGet,
        resourceContentList,
        updateFile,
        listAllWorkspaces,
        getWorkspace,
        initGitOnWorkspace,
        initGistOnWorkspace,
        initSnippetOnWorkspace,
        changeGitAuthSessionId,
        initLocalOnWorkspace,
        isFileModified,
        getGitServerRefs,
    ]);
    return (0, jsx_runtime_1.jsx)(WorkspacesContext_1.WorkspacesContext.Provider, __assign({ value: value }, { children: props.children }));
}
exports.WorkspacesContextProvider = WorkspacesContextProvider;
//# sourceMappingURL=WorkspacesContextProvider.js.map