import React, { useImperativeHandle, useState } from "react";
import _ from "lodash";
import TaskInbox from "./components/TaskInbox/TaskInbox";
import TaskInboxEnvelopeViewDriver from "./TaskInboxEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
import { getDefaultActiveTaskStates, getDefaultTaskStates } from "./components/utils/TaskInboxUtils";
export const TaskInboxEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [initialState, setInitialState] = useState();
    const [allTaskStates, setAllTaskStates] = useState(getDefaultTaskStates());
    const [activeTaskStates, setActiveTaskStates] = useState(getDefaultActiveTaskStates());
    const [currentUser, setCurrentUser] = useState("");
    useImperativeHandle(forwardedRef, () => ({
        initialize: (_initialState, _allTaskStates, _activeTaskStates) => {
            setInitialState(_initialState);
            if (!_.isEmpty(_allTaskStates)) {
                setAllTaskStates(_allTaskStates);
            }
            if (!_.isEmpty(_activeTaskStates)) {
                setActiveTaskStates(_activeTaskStates);
            }
            setEnvelopeConnectedToChannel(true);
        },
        notify: (userName) => {
            if (!_.isEmpty(userName)) {
                setCurrentUser(userName);
            }
            return Promise.resolve();
        },
    }), []);
    return (React.createElement(React.Fragment, null,
        React.createElement(TaskInbox, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new TaskInboxEnvelopeViewDriver(props.channelApi), initialState: initialState, allTaskStates: allTaskStates, activeTaskStates: activeTaskStates, currentUser: currentUser })));
});
export default TaskInboxEnvelopeView;
//# sourceMappingURL=TaskInboxEnvelopeView.js.map