import React, { useCallback } from "react";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { init } from "../envelope";
export const EmbeddedTaskDetails = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback((envelopeServer, container) => {
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.parent.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return envelopeServer.envelopeApi.requests.taskDetails__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, {
            task: props.userTask,
        });
    }, [props.userTask]);
    return (React.createElement(EmbeddedTaskDetailsEnvelope, { ref: forwardedRef, apiImpl: props, origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedTaskDetailsEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedTaskDetails.js.map