export default class ProcessDetailsEnvelopeViewDriver {
    constructor(channelApi) {
        this.channelApi = channelApi;
    }
    getProcessDiagram(data) {
        return this.channelApi.requests.processDetails__getProcessDiagram(data);
    }
    handleProcessAbort(processInstance) {
        return this.channelApi.requests.processDetails__handleProcessAbort(processInstance);
    }
    cancelJob(job) {
        return this.channelApi.requests.processDetails__cancelJob(job);
    }
    rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate) {
        return this.channelApi.requests.processDetails__rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate);
    }
    getTriggerableNodes(processInstance) {
        return this.channelApi.requests.processDetails__getTriggerableNodes(processInstance);
    }
    handleNodeTrigger(processInstance, node) {
        return this.channelApi.requests.processDetails__handleNodeTrigger(processInstance, node);
    }
    handleProcessVariableUpdate(processInstance, updatedJson) {
        return this.channelApi.requests.processDetails__handleProcessVariableUpdate(processInstance, updatedJson);
    }
    processDetailsQuery(id) {
        return this.channelApi.requests.processDetails__processDetailsQuery(id);
    }
    jobsQuery(id) {
        return this.channelApi.requests.processDetails__jobsQuery(id);
    }
    openProcessInstanceDetails(id) {
        return this.channelApi.notifications.processDetails__openProcessDetails.send(id);
    }
    handleProcessRetry(processInstance) {
        return this.channelApi.requests.processDetails__handleProcessRetry(processInstance);
    }
    handleNodeInstanceCancel(processInstance, node) {
        return this.channelApi.requests.processDetails__handleNodeInstanceCancel(processInstance, node);
    }
    handleProcessSkip(processInstance) {
        return this.channelApi.requests.processDetails__handleProcessSkip(processInstance);
    }
    handleNodeInstanceRetrigger(processInstance, node) {
        return this.channelApi.requests.processDetails__handleNodeInstanceRetrigger(processInstance, node);
    }
}
//# sourceMappingURL=ProcessDetailsEnvelopeViewDriver.js.map