import React from "react";
import { UndoIcon } from "@patternfly/react-icons/dist/js/icons/undo-icon";
import { ClockIcon } from "@patternfly/react-icons/dist/js/icons/clock-icon";
import { ErrorCircleOIcon } from "@patternfly/react-icons/dist/js/icons/error-circle-o-icon";
import { BanIcon } from "@patternfly/react-icons/dist/js/icons/ban-icon";
import { CheckCircleIcon } from "@patternfly/react-icons/dist/js/icons/check-circle-icon";
import { JobStatus } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
export const JobsIconCreator = (state) => {
    switch (state) {
        case JobStatus.Error:
            return (React.createElement(React.Fragment, null,
                React.createElement(ErrorCircleOIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" }),
                "Error"));
        case JobStatus.Canceled:
            return (React.createElement(React.Fragment, null,
                React.createElement(BanIcon, { className: "pf-u-mr-sm" }),
                "Canceled"));
        case JobStatus.Executed:
            return (React.createElement(React.Fragment, null,
                React.createElement(CheckCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--success-color--100)" }),
                "Executed"));
        case JobStatus.Retry:
            return (React.createElement(React.Fragment, null,
                React.createElement(UndoIcon, { className: "pf-u-mr-sm" }),
                "Retry"));
        case JobStatus.Scheduled:
            return (React.createElement(React.Fragment, null,
                React.createElement(ClockIcon, { className: "pf-u-mr-sm" }),
                "Scheduled"));
    }
};
//# sourceMappingURL=utils.js.map