var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useState, useEffect, useCallback } from "react";
import { Table, TableHeader, TableBody, sortable, } from "@patternfly/react-table/dist/js/components/Table";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import Moment from "react-moment";
import _ from "lodash";
import { JobsIconCreator } from "../../../utils/utils";
import { HistoryIcon } from "@patternfly/react-icons/dist/js/icons/history-icon";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { constructObject, setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
const JobsManagementTable = ({ jobs, driver, doQueryJobs, handleCancelModalToggle, handleDetailsToggle, handleRescheduleToggle, isActionPerformed, isLoading, setIsActionPerformed, selectedJobInstances, setModalTitle, setModalContent, setSelectedJobInstances, setSelectedJob, setSortBy, sortBy, setOrderBy, ouiaId, ouiaSafe, }) => {
    const [rows, setRows] = useState([]);
    const jobRow = [];
    const editableJobStatus = ["SCHEDULED", "ERROR"];
    const columns = [
        { title: "Id" },
        { title: "Status" },
        { title: "Expiration time" },
        { title: "Retries" },
        { title: "Execution counter" },
        { title: "Last update" },
    ];
    const checkNotEmpty = useCallback(() => {
        return jobs && jobs.length > 0 && !isLoading;
    }, [jobs, isLoading]);
    columns.map((column) => {
        column["props"] = { className: "pf-u-text-align-center" };
        checkNotEmpty() && column.title !== "Id" ? (column["transforms"] = [sortable]) : "";
        return column;
    });
    const getValues = (job) => {
        const tempRows = [];
        let jobType = "";
        for (const item in job) {
            if (item === "id") {
                const ele = {
                    title: (React.createElement(Tooltip, { content: job.id },
                        React.createElement("span", null, job.id.substring(0, 7)))),
                };
                tempRows.push(ele);
            }
            else if (item === "status") {
                const ele = {
                    title: JobsIconCreator(job.status),
                };
                if (editableJobStatus.includes(job[item])) {
                    jobType = "Editable";
                }
                else {
                    jobType = "Non-editable";
                }
                tempRows.push(ele);
            }
            else if (item === "expirationTime") {
                const ele = {
                    title: (React.createElement(React.Fragment, null, job.expirationTime ? (React.createElement(React.Fragment, null,
                        " ",
                        "expires in",
                        " ",
                        React.createElement(Moment, { fromNow: true, ago: true }, job.expirationTime))) : ("N/A"))),
                };
                tempRows.push(ele);
            }
            else if (item === "lastUpdate") {
                const ele = {
                    title: (React.createElement(React.Fragment, null,
                        React.createElement(HistoryIcon, { className: "pf-u-mr-sm" }),
                        " Updated ",
                        React.createElement(Moment, { fromNow: true }, job.lastUpdate))),
                };
                tempRows.push(ele);
            }
            else {
                const ele = {
                    title: React.createElement("span", null, job[item]),
                };
                tempRows.push(ele);
            }
        }
        return { tempRows, jobType };
    };
    const onSelect = (_event, isSelected, rowId, _rowData) => {
        if (!checkNotEmpty()) {
            return;
        }
        setIsActionPerformed(false);
        const copyOfRows = [...rows];
        if (rowId === -1) {
            copyOfRows.forEach((row) => {
                row.selected = isSelected;
                return row;
            });
            if (selectedJobInstances.length === jobs.length) {
                setSelectedJobInstances([]);
            }
            else if (selectedJobInstances.length < jobs.length) {
                setSelectedJobInstances(_.cloneDeep(jobs));
            }
        }
        else {
            if (copyOfRows[rowId]) {
                copyOfRows[rowId].selected = isSelected;
                const row = [...jobs].filter((job) => job.id === copyOfRows[rowId].rowKey);
                const rowData = _.find(selectedJobInstances, ["id", copyOfRows[rowId].rowKey]);
                if (rowData === undefined) {
                    setSelectedJobInstances([...selectedJobInstances, row[0]]);
                }
                else {
                    const copyOfSelectedJobInstances = [...selectedJobInstances];
                    _.remove(copyOfSelectedJobInstances, (job) => job.id === copyOfRows[rowId].rowKey);
                    setSelectedJobInstances(copyOfSelectedJobInstances);
                }
            }
        }
        setRows(copyOfRows);
    };
    const tableContent = (jobs) => {
        !isLoading &&
            !_.isEmpty(jobs) &&
            jobs.map((job) => {
                const retrievedValue = getValues(_.pick(job, ["id", "status", "expirationTime", "retries", "executionCounter", "lastUpdate"]));
                jobRow.push({
                    cells: retrievedValue.tempRows,
                    type: retrievedValue.jobType,
                    rowKey: job.id,
                    selected: false,
                });
            });
        if (isLoading) {
            const tempRows = [
                {
                    rowKey: "1",
                    cells: [
                        {
                            props: { colSpan: 8 },
                            title: React.createElement(KogitoSpinner, { spinnerText: "Loading jobs list..." }),
                        },
                    ],
                },
            ];
            setRows(tempRows);
        }
        else {
            if (jobRow.length === 0) {
                const tempRows = [
                    {
                        rowKey: "1",
                        cells: [
                            {
                                props: { colSpan: 8 },
                                title: (React.createElement(KogitoEmptyState, { type: KogitoEmptyStateType.Search, title: "No results found", body: "Try using different filters" })),
                            },
                        ],
                    },
                ];
                setRows(tempRows);
            }
            else {
                setRows((prev) => [...prev, ...jobRow]);
            }
        }
    };
    const handleJobDetails = (id) => {
        const job = jobs.find((job) => job.id === id);
        setSelectedJob(job);
        handleDetailsToggle();
    };
    const handleJobReschedule = (id) => {
        const job = jobs.find((job) => job.id === id);
        setSelectedJob(job);
        handleRescheduleToggle();
    };
    const handleCancelAction = (id) => __awaiter(void 0, void 0, void 0, function* () {
        const job = jobs.find((job) => job.id === id);
        const cancelResponse = yield driver.cancelJob(job);
        const title = setTitle(cancelResponse.modalTitle, "Job cancel");
        setModalTitle(title);
        setModalContent(cancelResponse.modalContent);
        handleCancelModalToggle();
    });
    const dynamicActions = (rowData) => {
        if (rowData.type === "Editable") {
            return [
                {
                    title: "Reschedule",
                    onClick: (_event, _rowId, rowData, _extra) => handleJobReschedule(rowData.rowKey),
                },
                {
                    title: "Cancel",
                    onClick: (_event, _rowId, rowData, _extra) => handleCancelAction(rowData.rowKey),
                },
            ];
        }
        else {
            return [];
        }
    };
    const actionResolver = (rowData) => {
        if (!checkNotEmpty()) {
            return [];
        }
        const editActions = dynamicActions(rowData);
        return [
            {
                title: "Details",
                onClick: (event, rowId, rowData, extra) => handleJobDetails(rowData.rowKey),
            },
            ...editActions,
        ];
    };
    const onSort = (event, index, direction) => __awaiter(void 0, void 0, void 0, function* () {
        setSortBy({ index, direction });
        let sortingColumn = event.target.innerText;
        sortingColumn = _.camelCase(sortingColumn);
        const obj = {};
        constructObject(obj, sortingColumn, direction.toUpperCase());
        setOrderBy(obj);
        yield driver.sortBy(obj);
        doQueryJobs(0, 10);
    });
    useEffect(() => {
        if (isActionPerformed) {
            const updatedRows = rows.filter((row) => {
                row.selected = false;
                return row;
            });
            setSelectedJobInstances([]);
            setRows(updatedRows);
        }
    }, [isActionPerformed]);
    useEffect(() => {
        setRows([]);
        tableContent(jobs);
    }, [isLoading, jobs]);
    return (React.createElement(Table, Object.assign({ cells: columns, rows: rows, onSelect: checkNotEmpty() ? onSelect : undefined, actionResolver: checkNotEmpty() ? actionResolver : undefined, sortBy: sortBy, onSort: onSort, "aria-label": "Jobs management Table", className: "kogito-jobs-management__table" }, componentOuiaProps(ouiaId, "jobs-management-table", ouiaSafe)),
        React.createElement(TableHeader, null),
        React.createElement(TableBody, null)));
};
export default JobsManagementTable;
//# sourceMappingURL=JobsManagementTable.js.map