var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useState } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { CardTitle } from "@patternfly/react-core/dist/js/components/Card";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { LoadMore } from "@kie-tools/runtime-tools-components/dist/components/LoadMore";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools/OuiaUtils";
import { JobStatus } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { BulkListType, } from "@kie-tools/runtime-tools-components/dist/components/BulkList";
import { OperationType, OrderBy } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import JobsManagementTable from "../JobsManagementTable/JobsManagementTable";
import JobsManagementToolbar from "../JobsManagementToolbar/JobsManagementToolbar";
import "../styles.css";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { JobsDetailsModal } from "../JobsDetailsModal";
import { JobsRescheduleModal } from "../JobsRescheduleModal";
import { JobsCancelModal } from "../JobsCancelModal";
export const formatForBulkListJob = (jobsList) => {
    const formattedItems = [];
    jobsList.forEach((item) => {
        const formattedObj = {
            id: item.id,
            name: item.processId,
            description: item.id,
            errorMessage: item.errorMessage ? item.errorMessage : undefined,
        };
        formattedItems.push(formattedObj);
    });
    return formattedItems;
};
const JobsManagement = ({ ouiaId, ouiaSafe, driver, isEnvelopeConnectedToChannel, }) => {
    const defaultPageSize = 10;
    const defaultStatus = [JobStatus.Scheduled];
    const defaultChip = [JobStatus.Scheduled];
    const defaultSortBy = { index: 6, direction: "asc" };
    const defaultOrderBy = {
        lastUpdate: OrderBy.ASC,
    };
    const [chips, setChips] = useState(defaultChip);
    const [selectedStatus, setSelectedStatus] = useState(defaultStatus);
    const [selectedJobInstances, setSelectedJobInstances] = useState([]);
    const [jobs, setJobs] = useState([]);
    const [displayTable, setDisplayTable] = useState(true);
    const [isLoading, setIsLoading] = useState(false);
    const [error, setError] = useState("");
    const [isActionPerformed, setIsActionPerformed] = useState(false);
    const [modalTitle, setModalTitle] = useState();
    const [modalContent, setModalContent] = useState("");
    const [sortBy, setSortBy] = useState(defaultSortBy);
    const [orderBy, setOrderBy] = useState(defaultOrderBy);
    const [limit, setLimit] = useState(defaultPageSize);
    const [offset, setOffset] = useState(0);
    const [pageSize, setPageSize] = useState(defaultPageSize);
    const [isLoadingMore, setIsLoadingMore] = useState(false);
    const [isCancelModalOpen, setIsCancelModalOpen] = useState(false);
    const [isDetailsModalOpen, setIsDetailsModalOpen] = useState(false);
    const [isRescheduleModalOpen, setIsRescheduleModalOpen] = useState(false);
    const [rescheduleError, setRescheduleError] = useState("");
    const [selectedJob, setSelectedJob] = useState({});
    const [jobOperationResults, setJobOperationResults] = useState({
        CANCEL: {
            successItems: [],
            failedItems: [],
            ignoredItems: [],
        },
    });
    const onRefresh = () => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        yield driver.initialLoad(selectedStatus, orderBy);
        setSortBy(defaultSortBy);
        setOffset(0);
        doQueryJobs(0, 10);
    });
    const initLoad = () => __awaiter(void 0, void 0, void 0, function* () {
        const defaultState = {
            filters: ["SCHEDULED"],
            sortBy: { lastUpdate: "ASC" },
        };
        setIsLoading(true);
        yield driver.initialLoad(defaultState.filters, defaultState.sortBy);
        doQueryJobs(0, 10);
    });
    const doQueryJobs = (_offset, _limit) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            const jobsResponse = yield driver.query(_offset, _limit);
            setIsLoading(false);
            setLimit(jobsResponse.length);
            if (_offset > 0 && jobs.length > 0) {
                setIsLoadingMore(false);
                const tempData = jobs.concat(jobsResponse);
                setJobs(tempData);
            }
            else {
                setJobs(jobsResponse);
            }
        }
        catch (err) {
            setError(err);
        }
    });
    React.useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            initLoad();
        }
    }, [isEnvelopeConnectedToChannel]);
    const handleCancelModalToggle = () => {
        setIsCancelModalOpen(!isCancelModalOpen);
    };
    const handleCancelModalCloseToggle = () => {
        setIsCancelModalOpen(!isCancelModalOpen);
        doQueryJobs(0, 10);
    };
    const handleDetailsToggle = () => {
        setIsDetailsModalOpen(!isDetailsModalOpen);
    };
    const handleRescheduleToggle = () => {
        setIsRescheduleModalOpen(!isRescheduleModalOpen);
    };
    const onGetMoreInstances = (initVal, _pageSize) => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoadingMore(true);
        setOffset(initVal);
        setPageSize(_pageSize);
        yield driver.initialLoad(selectedStatus, orderBy);
        doQueryJobs(initVal, _pageSize);
    });
    const handleBulkCancel = (cancelResults, ignoredJobs) => {
        setIsActionPerformed(true);
        setModalTitle(setTitle("success", "Job Cancel"));
        setModalContent("");
        setJobOperationResults(Object.assign(Object.assign({}, jobOperationResults), { [OperationType.CANCEL]: Object.assign(Object.assign({}, jobOperationResults[OperationType.CANCEL]), { successItems: formatForBulkListJob(cancelResults.successJobs), failedItems: formatForBulkListJob(cancelResults.failedJobs), ignoredItems: formatForBulkListJob(ignoredJobs) }) }));
        handleCancelModalToggle();
    };
    const jobOperations = {
        CANCEL: {
            type: BulkListType.JOB,
            results: jobOperationResults[OperationType.CANCEL],
            messages: {
                successMessage: "Canceled jobs: ",
                noItemsMessage: "No jobs were canceled",
                warningMessage: "Note: The job status has been updated. The list may appear inconsistent until you refresh any applied filters.",
                ignoredMessage: "These jobs were ignored because they were already canceled or executed.",
            },
            functions: {
                perform: () => __awaiter(void 0, void 0, void 0, function* () {
                    const ignoredJobs = [];
                    const remainingInstances = selectedJobInstances.filter((job) => {
                        if (job.status === JobStatus.Canceled || job.status === JobStatus.Executed) {
                            ignoredJobs.push(job);
                        }
                        else {
                            return true;
                        }
                    });
                    const cancelResults = yield driver.bulkCancel(remainingInstances);
                    handleBulkCancel(cancelResults, ignoredJobs);
                }),
            },
        },
    };
    const detailsAction = [
        React.createElement(Button, { key: "confirm-selection", variant: "primary", onClick: handleDetailsToggle }, "OK"),
    ];
    const rescheduleActions = [
        React.createElement(Button, { key: "cancel-reschedule", variant: "secondary", onClick: handleRescheduleToggle }, "Cancel"),
    ];
    const onResetToDefault = () => {
        setSelectedStatus(defaultStatus);
        setChips(defaultChip);
        setDisplayTable(true);
        initLoad();
    };
    const handleJobReschedule = (job, repeatInterval, repeatLimit, scheduleDate) => __awaiter(void 0, void 0, void 0, function* () {
        const response = yield driver.rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate);
        if (response && response.modalTitle === "success") {
            handleRescheduleToggle();
            setIsLoading(true);
            doQueryJobs(0, 10);
        }
        else if (response && response.modalTitle === "failure") {
            handleRescheduleToggle();
            setRescheduleError(response.modalContent);
            setIsLoading(true);
            doQueryJobs(0, 10);
        }
    });
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "JobsManagementPage", ouiaSafe ? ouiaSafe : !isLoading)),
        error.length === 0 ? (React.createElement(React.Fragment, null,
            React.createElement(CardTitle, null,
                React.createElement(JobsManagementToolbar, { chips: chips, onResetToDefault: onResetToDefault, driver: driver, doQueryJobs: doQueryJobs, jobOperations: jobOperations, onRefresh: onRefresh, selectedStatus: selectedStatus, selectedJobInstances: selectedJobInstances, setChips: setChips, setDisplayTable: setDisplayTable, setIsLoading: setIsLoading, setSelectedJobInstances: setSelectedJobInstances, setSelectedStatus: setSelectedStatus })),
            React.createElement(Divider, null),
            isEnvelopeConnectedToChannel && displayTable ? (React.createElement(JobsManagementTable, { jobs: jobs, driver: driver, doQueryJobs: doQueryJobs, handleCancelModalToggle: handleCancelModalToggle, handleDetailsToggle: handleDetailsToggle, handleRescheduleToggle: handleRescheduleToggle, isActionPerformed: isActionPerformed, isLoading: isLoadingMore ? false : isLoading, setIsActionPerformed: setIsActionPerformed, selectedJobInstances: selectedJobInstances, setModalTitle: setModalTitle, setModalContent: setModalContent, setSelectedJobInstances: setSelectedJobInstances, setSelectedJob: setSelectedJob, setSortBy: setSortBy, sortBy: sortBy, setOrderBy: setOrderBy })) : (React.createElement(React.Fragment, null, selectedStatus.length === 0 && (React.createElement("div", { className: "kogito-jobs-management__emptyState" },
                React.createElement(KogitoEmptyState, { type: KogitoEmptyStateType.Reset, title: "No filter applied.", body: "Try applying at least one filter to see results", onClick: () => onResetToDefault() }))))),
            isEnvelopeConnectedToChannel && (!isLoading || isLoadingMore) && (limit === pageSize || isLoadingMore) && (React.createElement(LoadMore, { offset: offset, setOffset: setOffset, getMoreItems: onGetMoreInstances, pageSize: pageSize, isLoadingMore: isLoadingMore })))) : (React.createElement(ServerErrors, { error: error, variant: "large" })),
        selectedJob && Object.keys(selectedJob).length > 0 && (React.createElement(JobsDetailsModal, { actionType: "Job Details", modalTitle: setTitle("success", "Job Details"), isModalOpen: isDetailsModalOpen, handleModalToggle: handleDetailsToggle, modalAction: detailsAction, job: selectedJob })),
        selectedJob && Object.keys(selectedJob).length > 0 && (React.createElement(JobsRescheduleModal, { actionType: "Job Reschedule", isModalOpen: isRescheduleModalOpen, handleModalToggle: handleRescheduleToggle, modalAction: rescheduleActions, job: selectedJob, rescheduleError: rescheduleError, setRescheduleError: setRescheduleError, handleJobReschedule: handleJobReschedule })),
        React.createElement(JobsCancelModal, { actionType: "Job Cancel", isModalOpen: isCancelModalOpen, handleModalToggle: handleCancelModalCloseToggle, modalTitle: modalTitle !== null && modalTitle !== void 0 ? modalTitle : React.createElement(React.Fragment, null), modalContent: modalContent, jobOperations: jobOperations[OperationType.CANCEL] })));
};
export default JobsManagement;
//# sourceMappingURL=JobsManagement.js.map