import { Meta, XmlParserTs } from "@kie-tools/xml-parser-ts";
import { root as dmn15root } from "./schemas/dmn-1_5/ts-gen/meta";
import { dmn3__tDefinitions as DMN10__tDefinitions } from "./schemas/dmn-1_0/ts-gen/types";
import { dmn__tDefinitions as DMN11__tDefinitions } from "./schemas/dmn-1_1/ts-gen/types";
import { DMN12__tDefinitions } from "./schemas/dmn-1_2/ts-gen/types";
import { DMN13__tDefinitions } from "./schemas/dmn-1_3/ts-gen/types";
import { DMN14__tDefinitions } from "./schemas/dmn-1_4/ts-gen/types";
import { DMN15__tDefinitions } from "./schemas/dmn-1_5/ts-gen/types";
import "./kie-extensions";
export declare type DmnMarshaller<V extends DmnMarshallerVersions = "latest"> = InternalDmnMarshaller<V> & {
    originalVersion: DmnVersions;
    isLatest: boolean;
};
export declare type InternalDmnMarshaller<V extends DmnMarshallerVersions = "latest"> = V extends "1.0" ? DmnMarshaller10 : V extends "1.1" ? DmnMarshaller11 : V extends "1.2" ? DmnMarshaller12 : V extends "1.3" ? DmnMarshaller13 : V extends "1.4" ? DmnMarshaller14 : V extends "1.5" ? DmnMarshaller15 : V extends "latest" ? DmnLatestMarshaller : never;
export declare type DmnMarshallerBase = {
    instanceNs: Map<string, string>;
    root: {
        element: string;
        type: string;
    };
    meta: Meta;
};
export declare type AllDmnMarshallers = DmnMarshaller10 | DmnMarshaller11 | DmnMarshaller12 | DmnMarshaller13 | DmnMarshaller14 | DmnMarshaller15;
export declare type KieExtensionVersions = "0.0" | "1.0";
export declare type DmnVersions = AllDmnMarshallers["version"];
export declare type DmnMarshallerVersions = AllDmnMarshallers["version"] | "latest";
export declare type DmnMarshaller10 = DmnMarshallerBase & {
    parser: {
        parse(): {
            Definitions: DMN10__tDefinitions;
        };
    };
    builder: {
        build(json: {
            Definitions: DMN10__tDefinitions;
        }): string;
    };
    version: "1.0";
};
export declare type DmnMarshaller11 = DmnMarshallerBase & {
    parser: {
        parse(): {
            definitions: DMN11__tDefinitions;
        };
    };
    builder: {
        build(json: {
            definitions: DMN11__tDefinitions;
        }): string;
    };
    version: "1.1";
};
export declare type DmnMarshaller12 = DmnMarshallerBase & {
    parser: {
        parse(): {
            definitions: DMN12__tDefinitions;
        };
    };
    builder: {
        build(json: {
            definitions: DMN12__tDefinitions;
        }): string;
    };
    version: "1.2";
};
export declare type DmnMarshaller13 = DmnMarshallerBase & {
    parser: {
        parse(): {
            definitions: DMN13__tDefinitions;
        };
    };
    builder: {
        build(json: {
            definitions: DMN13__tDefinitions;
        }): string;
    };
    version: "1.3";
};
export declare type DmnMarshaller14 = DmnMarshallerBase & {
    parser: {
        parse(): {
            definitions: DMN14__tDefinitions;
        };
    };
    builder: {
        build(json: {
            definitions: DMN14__tDefinitions;
        }): string;
    };
    version: "1.4";
};
export declare type DmnMarshaller15 = DmnMarshallerBase & {
    parser: {
        parse(): {
            definitions: DMN15__tDefinitions;
        };
    };
    builder: {
        build(json: {
            definitions: DMN15__tDefinitions;
        }): string;
    };
    version: "1.5";
};
export declare const DMN_PARSERS: Record<DmnVersions, XmlParserTs<any>>;
export declare const FEEL_NAMESPACES: Record<DmnVersions, string>;
export declare const DMN_VERSIONS_TIMELINE: DmnVersions[];
export declare const DMN_LATEST_VERSION: "1.5";
export declare type DmnLatestMarshaller = DmnMarshaller15;
export declare type DmnLatestModel = {
    [dmn15root.element]: DMN15__tDefinitions;
};
export declare type DmnMarshallerOpts<V extends DmnMarshallerVersions> = {
    upgradeTo?: V;
};
export declare function getMarshaller<V extends DmnMarshallerVersions>(xml: string, opts?: DmnMarshallerOpts<V>): DmnMarshaller<V>;
export declare function getKieExtensionVersion(instanceNs: Map<string, string>): KieExtensionVersions;
export declare function getDmnVersion(instanceNs: Map<string, string>): DmnVersions;
export declare function getMarshallerForFixedVersion(domdoc: Document, instanceNs: Map<string, string>): AllDmnMarshallers;
export declare function upgrade10to11(dmn10: {
    Definitions: DMN10__tDefinitions;
}): {
    definitions: DMN11__tDefinitions;
};
export declare function upgrade11to12(dmn11: {
    definitions: DMN11__tDefinitions;
}): {
    definitions: DMN12__tDefinitions;
};
export declare function upgrade12to13(dmn12: {
    definitions: DMN12__tDefinitions;
}): {
    definitions: DMN13__tDefinitions;
};
export declare function upgrade13to14(dmn13: {
    definitions: DMN13__tDefinitions;
}): {
    definitions: DMN14__tDefinitions;
};
export declare function upgrade14to15(dmn14: {
    definitions: DMN14__tDefinitions;
}): {
    definitions: DMN15__tDefinitions;
};
//# sourceMappingURL=index.d.ts.map