/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.drools.commands;

import java.util.Objects;

import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.RegistryContext;

public class SetActiveAgendaGroup implements ExecutableCommand<Void> {

    private final String agendaGroup;

    public SetActiveAgendaGroup(String agendaGroup) {
        this.agendaGroup = Objects.requireNonNull(agendaGroup);
    }

    @Override
    public Void execute(Context context) {
        KieSession ksession = ((RegistryContext) context).lookup(KieSession.class);

        ksession.getAgenda().getAgendaGroup(agendaGroup).setFocus();

        return null;
    }

    @Override
    public String toString() {
        return "SetActiveAgendaGroup{" +
                "agendaGroup='" + agendaGroup + '\'' +
                '}';
    }
}
