/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class CacheInvokeDirectResult
implements Message {
    private static final long serialVersionUID = 0L;
    private KeyCacheObject key;
    @GridToStringInclude
    private transient Object unprepareRes;
    @GridToStringInclude
    private CacheObject res;
    @GridToStringInclude(sensitive=true)
    @GridDirectTransient
    private Exception err;
    private byte[] errBytes;

    public CacheInvokeDirectResult() {
    }

    public CacheInvokeDirectResult(KeyCacheObject key, CacheObject res) {
        this.key = key;
        this.res = res;
    }

    static CacheInvokeDirectResult lazyResult(KeyCacheObject key, Object res) {
        CacheInvokeDirectResult res0 = new CacheInvokeDirectResult();
        res0.key = key;
        res0.unprepareRes = res;
        return res0;
    }

    public CacheInvokeDirectResult(KeyCacheObject key, Exception err) {
        this.key = key;
        this.err = err;
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public CacheObject result() {
        return this.res;
    }

    @Nullable
    public Exception error() {
        return this.err;
    }

    public void prepareMarshal(GridCacheContext ctx) throws IgniteCheckedException {
        this.key.prepareMarshal(ctx.cacheObjectContext());
        if (this.err != null && this.errBytes == null) {
            try {
                this.errBytes = U.marshal(ctx.marshaller(), (Object)this.err);
            }
            catch (IgniteCheckedException e) {
                IgniteCheckedException exc = new IgniteCheckedException(this.err.getMessage());
                exc.setStackTrace(this.err.getStackTrace());
                exc.addSuppressed(e);
                this.errBytes = U.marshal(ctx.marshaller(), (Object)exc);
            }
        }
        assert (this.unprepareRes == null) : "marshalResult() was not called for the result: " + this;
        if (this.res != null) {
            this.res.prepareMarshal(ctx.cacheObjectContext());
        }
    }

    public void marshalResult(GridCacheContext ctx) {
        try {
            if (this.unprepareRes != null) {
                this.res = ctx.toCacheObject(this.unprepareRes);
            }
        }
        finally {
            this.unprepareRes = null;
        }
    }

    public void finishUnmarshal(GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        this.key.finishUnmarshal(ctx.cacheObjectContext(), ldr);
        if (this.errBytes != null && this.err == null) {
            this.err = (Exception)U.unmarshal(ctx.marshaller(), this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.res != null) {
            this.res.finishUnmarshal(ctx.cacheObjectContext(), ldr);
        }
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public short directType() {
        return 93;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMessage("res", this.res)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.res = (CacheObject)reader.readMessage("res");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CacheInvokeDirectResult.class);
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    public String toString() {
        return S.toString(CacheInvokeDirectResult.class, this);
    }
}

