/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.connect;

import jakarta.inject.Inject;
import java.net.URL;
import org.apache.ignite.internal.cli.call.connect.ConnectCallInput;
import org.apache.ignite.internal.cli.call.connect.ConnectWizardCall;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.connect.ConnectOptions;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.converters.RestEndpointUrlConverter;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import picocli.CommandLine;

@CommandLine.Command(name="connect", description={"Connects to Ignite 3 node"})
public class ConnectReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Parameters(description={"URL of a node that will be used as a communication endpoint. It can be any node URL. If not set, then the default URL from the profile settings will be used"}, descriptionKey="ignite.cluster-endpoint-url", converter={RestEndpointUrlConverter.class})
    private URL nodeUrl;
    @CommandLine.ArgGroup(exclusive=false)
    private ConnectOptions connectOptions;
    @Inject
    private ConnectWizardCall connectCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfConnected(this.connectCallInput(this.nodeUrl.toString())).then(Flows.fromCall(this.connectCall)).print());
    }

    private ConnectCallInput connectCallInput(String nodeUrl) {
        return ConnectCallInput.builder().url(nodeUrl).username(this.connectOptions != null ? this.connectOptions.username() : null).password(this.connectOptions != null ? this.connectOptions.password() : null).checkClusterInit(true).build();
    }
}

