/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.pool;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.TimeValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestPoolEntry {
    private AtomicLong count;
    private Supplier<Long> currentTimeSupplier;

    TestPoolEntry() {
    }

    @BeforeEach
    void setup() {
        this.count = new AtomicLong(1L);
        this.currentTimeSupplier = () -> this.count.addAndGet(1L);
    }

    @Test
    void testBasics() {
        PoolEntry entry1 = new PoolEntry((Object)"route1", TimeValue.of((long)10L, (TimeUnit)TimeUnit.MILLISECONDS), this.currentTimeSupplier);
        Assertions.assertEquals((Object)"route1", (Object)entry1.getRoute());
        Assertions.assertEquals((long)0L, (long)entry1.getUpdated());
        Assertions.assertEquals((Object)Deadline.MIN_VALUE, (Object)entry1.getExpiryDeadline());
        entry1.assignConnection((ModalCloseable)Mockito.mock(HttpConnection.class));
        long now = System.currentTimeMillis();
        Assertions.assertEquals((Object)"route1", (Object)entry1.getRoute());
        Assertions.assertTrue((now >= entry1.getUpdated() ? 1 : 0) != 0);
        Assertions.assertEquals((Object)entry1.getValidityDeadline(), (Object)entry1.getExpiryDeadline());
        Assertions.assertEquals((long)(entry1.getUpdated() + 10L), (long)entry1.getValidityDeadline().getValue());
        entry1.discardConnection(CloseMode.IMMEDIATE);
        Assertions.assertEquals((long)0L, (long)entry1.getUpdated());
        Assertions.assertEquals((Object)Deadline.MIN_VALUE, (Object)entry1.getExpiryDeadline());
    }

    @Test
    void testNullConstructor() {
        Assertions.assertThrows(NullPointerException.class, () -> new PoolEntry(null));
    }

    @Test
    void testValidInfinitely() {
        PoolEntry entry1 = new PoolEntry((Object)"route1", TimeValue.ZERO_MILLISECONDS, this.currentTimeSupplier);
        entry1.assignConnection((ModalCloseable)Mockito.mock(HttpConnection.class));
        Assertions.assertEquals((Object)Deadline.MAX_VALUE, (Object)entry1.getValidityDeadline());
        Assertions.assertEquals((Object)entry1.getValidityDeadline(), (Object)entry1.getExpiryDeadline());
    }

    @Test
    void testExpiry() {
        PoolEntry entry1 = new PoolEntry((Object)"route1", TimeValue.ZERO_MILLISECONDS, this.currentTimeSupplier);
        entry1.assignConnection((ModalCloseable)Mockito.mock(HttpConnection.class));
        Assertions.assertEquals((Object)Deadline.MAX_VALUE, (Object)entry1.getExpiryDeadline());
        entry1.updateExpiry(TimeValue.of((long)50L, (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)(entry1.getUpdated() + 50L), (long)entry1.getExpiryDeadline().getValue());
        entry1.updateExpiry(TimeValue.ZERO_MILLISECONDS);
        Assertions.assertEquals((Object)Deadline.MAX_VALUE, (Object)entry1.getExpiryDeadline());
        PoolEntry entry2 = new PoolEntry((Object)"route1", TimeValue.of((long)100L, (TimeUnit)TimeUnit.MILLISECONDS), this.currentTimeSupplier);
        entry2.assignConnection((ModalCloseable)Mockito.mock(HttpConnection.class));
        Deadline validityDeadline = entry2.getValidityDeadline();
        Assertions.assertEquals((long)(entry2.getUpdated() + 100L), (long)entry2.getExpiryDeadline().getValue());
        entry2.updateExpiry(TimeValue.of((long)50L, (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((long)(entry2.getUpdated() + 50L), (long)entry2.getExpiryDeadline().getValue());
        entry2.updateExpiry(TimeValue.of((long)150L, (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((Object)validityDeadline, (Object)entry2.getExpiryDeadline());
    }

    @Test
    void testInvalidExpiry() {
        PoolEntry entry = new PoolEntry((Object)"route1", TimeValue.of((long)0L, (TimeUnit)TimeUnit.MILLISECONDS), this.currentTimeSupplier);
        Assertions.assertThrows(NullPointerException.class, () -> entry.updateExpiry(null));
    }

    @Test
    void testExpiryDoesNotOverflow() {
        PoolEntry entry = new PoolEntry((Object)"route1", TimeValue.of((long)Long.MAX_VALUE, (TimeUnit)TimeUnit.MILLISECONDS), this.currentTimeSupplier);
        entry.assignConnection((ModalCloseable)Mockito.mock(HttpConnection.class));
        Assertions.assertEquals((Object)Deadline.MAX_VALUE, (Object)entry.getValidityDeadline());
    }
}

