/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.range;

import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.service.reads.DataResolver;
import org.apache.cassandra.service.reads.ReadCallback;
import org.apache.cassandra.service.reads.repair.ReadRepair;
import org.apache.cassandra.utils.AbstractIterator;

class SingleRangeResponse
extends AbstractIterator<RowIterator>
implements PartitionIterator {
    private final DataResolver<EndpointsForRange, ReplicaPlan.ForRangeRead> resolver;
    private final ReadCallback<EndpointsForRange, ReplicaPlan.ForRangeRead> handler;
    private final ReadRepair<EndpointsForRange, ReplicaPlan.ForRangeRead> readRepair;
    private PartitionIterator result;

    SingleRangeResponse(DataResolver<EndpointsForRange, ReplicaPlan.ForRangeRead> resolver, ReadCallback<EndpointsForRange, ReplicaPlan.ForRangeRead> handler, ReadRepair<EndpointsForRange, ReplicaPlan.ForRangeRead> readRepair) {
        this.resolver = resolver;
        this.handler = handler;
        this.readRepair = readRepair;
    }

    ReadRepair<EndpointsForRange, ReplicaPlan.ForRangeRead> getReadRepair() {
        return this.readRepair;
    }

    private void waitForResponse() throws ReadTimeoutException {
        if (this.result != null) {
            return;
        }
        this.handler.awaitResults();
        this.result = this.resolver.resolve();
    }

    @Override
    protected RowIterator computeNext() {
        this.waitForResponse();
        return this.result.hasNext() ? (RowIterator)this.result.next() : (RowIterator)this.endOfData();
    }

    @Override
    public void close() {
        if (this.result != null) {
            this.result.close();
        }
    }
}

