/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaWriteSchemaTransformProvider_KafkaWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SchemaTransformProvider.class})
public class KafkaWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<KafkaWriteSchemaTransformConfiguration> {
    public static final @UnknownKeyFor @NonNull @Initialized String SUPPORTED_FORMATS_STR = "JSON,AVRO";
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> SUPPORTED_FORMATS = Sets.newHashSet((Object[])"JSON,AVRO".split(","));
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> ERROR_TAG = new TupleTag<Row>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> OUTPUT_TAG = new TupleTag<KV<byte[], byte[]>>(){};
    public static final @UnknownKeyFor @NonNull @Initialized Schema ERROR_SCHEMA = Schema.builder().addStringField("error").addNullableByteArrayField("row").build();
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KafkaWriteSchemaTransformProvider.class);

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized KafkaWriteSchemaTransformConfiguration> configurationClass() {
        return KafkaWriteSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized KafkaWriteSchemaTransformConfiguration configuration) {
        if (!SUPPORTED_FORMATS.contains(configuration.getFormat())) {
            throw new IllegalArgumentException("Format " + configuration.getFormat() + " is not supported. Supported formats are: " + String.join((CharSequence)", ", SUPPORTED_FORMATS));
        }
        return new KafkaWriteSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:kafka_write:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList("input");
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.emptyList();
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class KafkaWriteSchemaTransformConfiguration
    implements Serializable {
        @SchemaFieldDescription(value="The encoding format for the data stored in Kafka. Valid options are: JSON,AVRO")
        public abstract @UnknownKeyFor @NonNull @Initialized String getFormat();

        public abstract @UnknownKeyFor @NonNull @Initialized String getTopic();

        @SchemaFieldDescription(value="A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping\u2014this list only impacts the initial hosts used to discover the full set of servers. | Format: host1:port1,host2:port2,...")
        public abstract @UnknownKeyFor @NonNull @Initialized String getBootstrapServers();

        @SchemaFieldDescription(value="A list of key-value pairs that act as configuration parameters for Kafka producers. Most of these configurations will not be needed, but if you need to customize your Kafka producer, you may use this. See a detailed list: https://docs.confluent.io/platform/current/installation/configuration/producer-configs.html")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getProducerConfigUpdates();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_KafkaWriteSchemaTransformProvider_KafkaWriteSchemaTransformConfiguration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFormat(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTopic(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setBootstrapServers(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProducerConfigUpdates(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized KafkaWriteSchemaTransformConfiguration build();
        }
    }

    static final class KafkaWriteSchemaTransform
    extends SchemaTransform
    implements Serializable {
        final @UnknownKeyFor @NonNull @Initialized KafkaWriteSchemaTransformConfiguration configuration;

        KafkaWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized KafkaWriteSchemaTransformConfiguration configuration) {
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Schema inputSchema = input.get("input").getSchema();
            SimpleFunction toBytesFn = this.configuration.getFormat().equals("JSON") ? JsonUtils.getRowToJsonBytesFunction((Schema)inputSchema) : AvroUtils.getRowToAvroBytesFunction((Schema)inputSchema);
            Map<String, String> configOverrides = this.configuration.getProducerConfigUpdates();
            PCollectionTuple outputTuple = (PCollectionTuple)input.get("input").apply("Map rows to Kafka messages", (PTransform)ParDo.of((DoFn)new ErrorCounterFn("Kafka-write-error-counter", (SerializableFunction<Row, byte[]>)toBytesFn)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
            outputTuple.get(OUTPUT_TAG).apply(KafkaIO.write().withTopic(this.configuration.getTopic()).withBootstrapServers(this.configuration.getBootstrapServers()).withProducerConfigUpdates(configOverrides == null ? new HashMap<String, Object>() : new HashMap<String, String>(configOverrides)).withKeySerializer(ByteArraySerializer.class).withValueSerializer(ByteArraySerializer.class));
            return PCollectionRowTuple.of((String)"errors", (PCollection)outputTuple.get(ERROR_TAG).setRowSchema(ERROR_SCHEMA));
        }

        public static class ErrorCounterFn
        extends DoFn<Row, KV<byte[], byte[]>> {
            private @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toBytesFn;
            private @UnknownKeyFor @NonNull @Initialized Counter errorCounter;
            private @UnknownKeyFor @NonNull @Initialized Long errorsInBundle = 0L;

            public ErrorCounterFn(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toBytesFn) {
                this.toBytesFn = toBytesFn;
                this.errorCounter = Metrics.counter(KafkaWriteSchemaTransformProvider.class, (String)name);
            }

            @DoFn.ProcessElement
            public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) {
                try {
                    receiver.get(OUTPUT_TAG).output((Object)KV.of((Object)new byte[1], (Object)((byte[])this.toBytesFn.apply((Object)row))));
                }
                catch (Exception e) {
                    this.errorsInBundle = this.errorsInBundle + 1L;
                    LOG.warn("Error while processing the element", (Throwable)e);
                    receiver.get(ERROR_TAG).output((Object)Row.withSchema((Schema)ERROR_SCHEMA).addValues(new Object[]{e.toString(), row.toString()}).build());
                }
            }

            @DoFn.FinishBundle
            public void finish() {
                this.errorCounter.inc(this.errorsInBundle.longValue());
                this.errorsInBundle = 0L;
            }
        }
    }
}

