/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo;

import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.TaggableReadPreference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public enum NamedReadPreference {
    PRIMARY(ReadPreference.primary()),
    PRIMARY_PREFERRED(ReadPreference.primaryPreferred()),
    SECONDARY(ReadPreference.secondary()),
    SECONDARY_PREFERRED(ReadPreference.secondaryPreferred()),
    NEAREST(ReadPreference.nearest());

    private ReadPreference pref = null;

    private NamedReadPreference(ReadPreference pref) {
        this.pref = pref;
    }

    public String getName() {
        return this.pref.getName();
    }

    public ReadPreference getPreference() {
        return this.pref;
    }

    public static Collection<String> getPreferenceNames() {
        ArrayList<String> prefs = new ArrayList<String>();
        for (NamedReadPreference preference : NamedReadPreference.values()) {
            prefs.add(preference.getName());
        }
        return prefs;
    }

    public ReadPreference getTaggableReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
        switch (this) {
            case PRIMARY_PREFERRED: {
                return ReadPreference.primaryPreferred(NamedReadPreference.toTagsList(firstTagSet, remainingTagSets));
            }
            case SECONDARY: {
                return ReadPreference.secondary(NamedReadPreference.toTagsList(firstTagSet, remainingTagSets));
            }
            case SECONDARY_PREFERRED: {
                return ReadPreference.secondaryPreferred(NamedReadPreference.toTagsList(firstTagSet, remainingTagSets));
            }
            case NEAREST: {
                return ReadPreference.nearest(NamedReadPreference.toTagsList(firstTagSet, remainingTagSets));
            }
        }
        return this.pref instanceof TaggableReadPreference ? this.pref : null;
    }

    private static List<TagSet> toTagsList(DBObject firstTagSet, DBObject[] remainingTagSets) {
        ArrayList<TagSet> tagsList = new ArrayList<TagSet>(remainingTagSets.length + 1);
        tagsList.add(NamedReadPreference.toTags(firstTagSet));
        for (DBObject cur : remainingTagSets) {
            tagsList.add(NamedReadPreference.toTags(cur));
        }
        return tagsList;
    }

    private static TagSet toTags(DBObject tagsDocument) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (String key : tagsDocument.keySet()) {
            tagList.add(new Tag(key, tagsDocument.get(key).toString()));
        }
        return new TagSet(tagList);
    }

    public static NamedReadPreference byName(String preferenceName) {
        NamedReadPreference foundPreference = null;
        for (NamedReadPreference preference : NamedReadPreference.values()) {
            if (!preference.getName().equalsIgnoreCase(preferenceName)) continue;
            foundPreference = preference;
            break;
        }
        return foundPreference;
    }
}

