/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.i18n;

import org.apache.commons.vfs2.FileObject;

public class KeyOccurrence
implements Comparable<KeyOccurrence> {
    private FileObject fileObject;
    private String sourceFolder;
    private String messagesPackage;
    private int fileIndex;
    private String key;
    private String arguments;
    private int occurrences = 0;
    private String sourceLine;

    public KeyOccurrence() {
    }

    public KeyOccurrence(FileObject fileObject, String sourceFolder, String messagesPackage, int fileIndex, String key, String arguments, String sourceLine) {
        this();
        if (fileObject == null) {
            throw new RuntimeException("A key occurrence needs to have a file in which it occurs");
        }
        if (messagesPackage == null) {
            throw new RuntimeException("A key occurrence needs to have a messages package in file '" + fileObject + "'");
        }
        this.fileObject = fileObject;
        this.sourceFolder = sourceFolder;
        this.messagesPackage = messagesPackage;
        this.fileIndex = fileIndex;
        this.key = key;
        this.arguments = arguments;
        this.occurrences = 1;
        this.sourceLine = sourceLine;
    }

    public String toString() {
        return "[source=" + this.sourceFolder + ", key=" + this.key + ", messages package=" + this.messagesPackage + "]";
    }

    public boolean equals(Object occ) {
        if (occ == null) {
            return false;
        }
        if (this == occ) {
            return true;
        }
        return this.sourceFolder.equals(((KeyOccurrence)occ).sourceFolder) && this.key.equals(((KeyOccurrence)occ).key) && this.messagesPackage.equals(((KeyOccurrence)occ).messagesPackage);
    }

    @Override
    public int compareTo(KeyOccurrence occ) {
        int cmp = this.key.compareTo(occ.key);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.messagesPackage.compareTo(occ.messagesPackage);
        return cmp;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public void setFileObject(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public String getMessagesPackage() {
        return this.messagesPackage;
    }

    public void setMessagesPackage(String messagesPackage) {
        this.messagesPackage = messagesPackage;
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int fileIndex) {
        this.fileIndex = fileIndex;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(int occurrences) {
        this.occurrences = occurrences;
    }

    public void incrementOccurrences() {
        ++this.occurrences;
    }

    public String getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(String sourceLine) {
        this.sourceLine = sourceLine;
    }
}

