/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.dialog;

import org.apache.hop.core.Const;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class NotePadDialog
extends Dialog {
    private static final Class<?> PKG = NotePadDialog.class;
    private NotePadMeta notePadMeta;
    private StyledTextComp wDesc;
    private Shell shell;
    private String title;
    private PropsUi props;
    private CTabFolder wNoteFolder;
    private CCombo wFontName;
    private Spinner wFontSize;
    private Button wFontBold;
    private Button wFontItalic;
    private Label wBackGroundColor;
    private Label wFontColor;
    private Label wBorderColor;
    private GuiResource guiresource = GuiResource.getInstance();
    public RGB COLOR_RGB_BLACK = this.guiresource.getColorBlack().getRGB();
    public RGB COLOR_RGB_YELLOW = this.guiresource.getColorYellow().getRGB();
    public RGB COLOR_RGB_GRAY = this.guiresource.getColorGray().getRGB();
    private Color fontColor;
    private Color bgColor;
    private Color borderColor;
    private Font font;
    private IVariables variables;

    public NotePadDialog(IVariables variables, Shell parent, String title, NotePadMeta nMeta) {
        super(parent, 0);
        this.props = PropsUi.getInstance();
        this.title = title;
        if (nMeta != null) {
            this.notePadMeta = nMeta;
        }
        this.variables = variables;
    }

    public NotePadDialog(IVariables variables, Shell parent, String title) {
        this(variables, parent, title, null);
    }

    public NotePadMeta open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(this.guiresource.getImageNote());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        NotePadDialog notePadDialog = this;
        int margin = notePadDialog.props.getMargin();
        int middle = 30;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk, wCancel}, margin, null);
        this.wNoteFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wNoteFolder, 4);
        CTabItem wNoteContentTab = new CTabItem(this.wNoteFolder, 0);
        wNoteContentTab.setFont(GuiResource.getInstance().getFontDefault());
        wNoteContentTab.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.ContentTab.Note", (String[])new String[0]));
        Composite wNoteContentComp = new Composite((Composite)this.wNoteFolder, 0);
        PropsUi.setLook((Widget)wNoteContentComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wNoteContentComp.setLayout((Layout)fileLayout);
        Label wlDesc = new Label(wNoteContentComp, 0);
        wlDesc.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.ContentTab.Note.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDesc);
        FormData fdlDesc = new FormData();
        fdlDesc.left = new FormAttachment(0, 0);
        fdlDesc.top = new FormAttachment(0, margin);
        wlDesc.setLayoutData((Object)fdlDesc);
        this.wDesc = new StyledTextComp(this.variables, wNoteContentComp, 19202);
        this.wDesc.setText("");
        FormData fdDesc = new FormData();
        fdDesc.left = new FormAttachment(0, 0);
        fdDesc.top = new FormAttachment((Control)wlDesc, margin);
        fdDesc.right = new FormAttachment(100, -10);
        fdDesc.bottom = new FormAttachment(100, -margin);
        this.wDesc.setLayoutData(fdDesc);
        FormData fdNoteContentComp = new FormData();
        fdNoteContentComp.left = new FormAttachment(0, 0);
        fdNoteContentComp.top = new FormAttachment(0, 0);
        fdNoteContentComp.right = new FormAttachment(100, 0);
        fdNoteContentComp.bottom = new FormAttachment(100, 0);
        wNoteContentComp.setLayoutData((Object)fdNoteContentComp);
        wNoteContentComp.layout();
        wNoteContentTab.setControl((Control)wNoteContentComp);
        CTabItem wNoteFontTab = new CTabItem(this.wNoteFolder, 0);
        wNoteFontTab.setFont(GuiResource.getInstance().getFontDefault());
        wNoteFontTab.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Label", (String[])new String[0]));
        Composite wNoteFontComp = new Composite((Composite)this.wNoteFolder, 0);
        PropsUi.setLook((Widget)wNoteFontComp);
        FormLayout notefontLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wNoteFontComp.setLayout((Layout)notefontLayout);
        Label wlFontName = new Label(wNoteFontComp, 131072);
        wlFontName.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFontName);
        FormData fdlFontName = new FormData();
        fdlFontName.left = new FormAttachment(margin, margin);
        fdlFontName.top = new FormAttachment(0, 3 * margin);
        fdlFontName.right = new FormAttachment(middle, -margin);
        wlFontName.setLayoutData((Object)fdlFontName);
        this.wFontName = new CCombo(wNoteFontComp, 2056);
        this.wFontName.setItems(Const.getAvailableFontNames());
        PropsUi.setLook((Widget)this.wFontName);
        FormData fdFontName = new FormData();
        fdFontName.left = new FormAttachment(middle, 0);
        fdFontName.top = new FormAttachment(0, 3 * margin);
        fdFontName.right = new FormAttachment(100, -margin);
        this.wFontName.setLayoutData((Object)fdFontName);
        this.wFontName.select(0);
        this.wFontName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NotePadDialog.this.refreshTextNote();
            }
        });
        Label wlFontSize = new Label(wNoteFontComp, 131072);
        wlFontSize.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Size.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFontSize);
        FormData fdlFontSize = new FormData();
        fdlFontSize.left = new FormAttachment(margin, margin);
        fdlFontSize.top = new FormAttachment((Control)this.wFontName, margin);
        fdlFontSize.right = new FormAttachment(middle, -margin);
        wlFontSize.setLayoutData((Object)fdlFontSize);
        this.wFontSize = new Spinner(wNoteFontComp, 2048);
        this.wFontSize.setMinimum(0);
        this.wFontSize.setMaximum(70);
        this.wFontSize.setIncrement(1);
        FormData fdFontSize = new FormData();
        fdFontSize.left = new FormAttachment(middle, 0);
        fdFontSize.top = new FormAttachment((Control)this.wFontName, margin);
        fdFontSize.right = new FormAttachment(100, -margin);
        this.wFontSize.setLayoutData((Object)fdFontSize);
        this.wFontSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NotePadDialog.this.refreshTextNote();
            }
        });
        Label wlFontBold = new Label(wNoteFontComp, 131072);
        wlFontBold.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Bold.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFontBold);
        FormData fdlFontBold = new FormData();
        fdlFontBold.left = new FormAttachment(margin, margin);
        fdlFontBold.top = new FormAttachment((Control)this.wFontSize, margin);
        fdlFontBold.right = new FormAttachment(middle, -margin);
        wlFontBold.setLayoutData((Object)fdlFontBold);
        this.wFontBold = new Button(wNoteFontComp, 32);
        PropsUi.setLook((Widget)this.wFontBold);
        FormData fdFontBold = new FormData();
        fdFontBold.left = new FormAttachment(middle, 0);
        fdFontBold.top = new FormAttachment((Control)wlFontBold, 0, 0x1000000);
        fdFontBold.right = new FormAttachment(100, -margin);
        this.wFontBold.setLayoutData((Object)fdFontBold);
        this.wFontBold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NotePadDialog.this.refreshTextNote();
            }
        });
        Label wlFontItalic = new Label(wNoteFontComp, 131072);
        wlFontItalic.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Italic.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFontItalic);
        FormData fdlFontItalic = new FormData();
        fdlFontItalic.left = new FormAttachment(margin, margin);
        fdlFontItalic.top = new FormAttachment((Control)wlFontBold, margin);
        fdlFontItalic.right = new FormAttachment(middle, -margin);
        wlFontItalic.setLayoutData((Object)fdlFontItalic);
        this.wFontItalic = new Button(wNoteFontComp, 32);
        PropsUi.setLook((Widget)this.wFontItalic);
        FormData fdFontItalic = new FormData();
        fdFontItalic.left = new FormAttachment(middle, 0);
        fdFontItalic.top = new FormAttachment((Control)wlFontItalic, 0, 0x1000000);
        fdFontItalic.right = new FormAttachment(100, -margin);
        this.wFontItalic.setLayoutData((Object)fdFontItalic);
        this.wFontItalic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NotePadDialog.this.refreshTextNote();
            }
        });
        Label wlFontColor = new Label(wNoteFontComp, 131072);
        wlFontColor.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Color.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFontColor);
        FormData fdlFontColor = new FormData();
        fdlFontColor.left = new FormAttachment(margin, margin);
        fdlFontColor.top = new FormAttachment((Control)this.wFontItalic, 2 * margin);
        fdlFontColor.right = new FormAttachment(middle, -margin);
        wlFontColor.setLayoutData((Object)fdlFontColor);
        Button wbFontColorChange = new Button(wNoteFontComp, 8);
        wbFontColorChange.setImage(this.guiresource.getImageColor());
        wbFontColorChange.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Color.Change.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wbFontColorChange);
        FormData fdFontColorChange = new FormData();
        fdFontColorChange.top = new FormAttachment((Control)wlFontItalic, 2 * margin);
        fdFontColorChange.right = new FormAttachment(100, -margin);
        wbFontColorChange.setLayoutData((Object)fdFontColorChange);
        wbFontColorChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(NotePadDialog.this.shell);
                cd.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Color.Dialog.Label", (String[])new String[0]));
                cd.setRGB(NotePadDialog.this.wFontColor.getBackground().getRGB());
                RGB newColor = cd.open();
                if (newColor == null) {
                    return;
                }
                NotePadDialog.this.fontColor.dispose();
                NotePadDialog.this.fontColor = new Color((Device)NotePadDialog.this.shell.getDisplay(), newColor);
                NotePadDialog.this.wFontColor.setBackground(NotePadDialog.this.fontColor);
                NotePadDialog.this.refreshTextNote();
            }
        });
        this.wFontColor = new Label(wNoteFontComp, 0);
        this.wFontColor.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Color.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFontColor);
        this.wFontColor.setEnabled(false);
        FormData fdFontColor = new FormData();
        fdFontColor.left = new FormAttachment((Control)wlFontColor, margin);
        fdFontColor.top = new FormAttachment((Control)this.wFontItalic, 2 * margin);
        fdFontColor.right = new FormAttachment((Control)wbFontColorChange, -margin);
        this.wFontColor.setLayoutData((Object)fdFontColor);
        Label wlBackGroundColor = new Label(wNoteFontComp, 131072);
        wlBackGroundColor.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BackGroundColor.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBackGroundColor);
        FormData fdlBackGroundColor = new FormData();
        fdlBackGroundColor.left = new FormAttachment(margin, margin);
        fdlBackGroundColor.top = new FormAttachment((Control)this.wFontColor, 2 * margin);
        fdlBackGroundColor.right = new FormAttachment(middle, -margin);
        wlBackGroundColor.setLayoutData((Object)fdlBackGroundColor);
        Button wbBackGroundColorChange = new Button(wNoteFontComp, 8);
        wbBackGroundColorChange.setImage(this.guiresource.getImageColor());
        wbBackGroundColorChange.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BackGroundColor.Change.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wbBackGroundColorChange);
        FormData fdBackGroundColorChange = new FormData();
        fdBackGroundColorChange.top = new FormAttachment((Control)this.wFontColor, 2 * margin);
        fdBackGroundColorChange.right = new FormAttachment(100, -margin);
        fdBackGroundColorChange.right = new FormAttachment(100, -margin);
        wbBackGroundColorChange.setLayoutData((Object)fdBackGroundColorChange);
        wbBackGroundColorChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(NotePadDialog.this.shell);
                cd.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Color.Dialog.Label", (String[])new String[0]));
                cd.setRGB(NotePadDialog.this.wBackGroundColor.getBackground().getRGB());
                RGB newColor = cd.open();
                if (newColor == null) {
                    return;
                }
                NotePadDialog.this.bgColor.dispose();
                NotePadDialog.this.bgColor = new Color((Device)NotePadDialog.this.shell.getDisplay(), newColor);
                NotePadDialog.this.wBackGroundColor.setBackground(NotePadDialog.this.bgColor);
                NotePadDialog.this.refreshTextNote();
            }
        });
        this.wBackGroundColor = new Label(wNoteFontComp, 2048);
        this.wBackGroundColor.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BackGroundColor.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wBackGroundColor);
        this.wBackGroundColor.setEnabled(false);
        FormData fdBackGroundColor = new FormData();
        fdBackGroundColor.left = new FormAttachment((Control)wlBackGroundColor, margin);
        fdBackGroundColor.top = new FormAttachment((Control)this.wFontColor, 2 * margin);
        fdBackGroundColor.right = new FormAttachment((Control)wbBackGroundColorChange, -margin);
        this.wBackGroundColor.setLayoutData((Object)fdBackGroundColor);
        Label wlBorderColor = new Label(wNoteFontComp, 131072);
        wlBorderColor.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BorderColor.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBorderColor);
        FormData fdlBorderColor = new FormData();
        fdlBorderColor.left = new FormAttachment(margin, margin);
        fdlBorderColor.top = new FormAttachment((Control)this.wBackGroundColor, 2 * margin);
        fdlBorderColor.right = new FormAttachment(middle, -margin);
        wlBorderColor.setLayoutData((Object)fdlBorderColor);
        Button wbBorderColorChange = new Button(wNoteFontComp, 8);
        wbBorderColorChange.setImage(this.guiresource.getImageColor());
        wbBorderColorChange.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BorderColor.Change.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wbBorderColorChange);
        FormData fdBorderColorChange = new FormData();
        fdBorderColorChange.top = new FormAttachment((Control)this.wBackGroundColor, 2 * margin);
        fdBorderColorChange.right = new FormAttachment(100, -margin);
        wbBorderColorChange.setLayoutData((Object)fdBorderColorChange);
        wbBorderColorChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(NotePadDialog.this.shell);
                cd.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Color.Dialog.Label", (String[])new String[0]));
                cd.setRGB(NotePadDialog.this.wBorderColor.getBackground().getRGB());
                RGB newColor = cd.open();
                if (newColor == null) {
                    return;
                }
                NotePadDialog.this.borderColor.dispose();
                NotePadDialog.this.borderColor = new Color((Device)NotePadDialog.this.shell.getDisplay(), newColor);
                NotePadDialog.this.wBorderColor.setBackground(NotePadDialog.this.borderColor);
            }
        });
        this.wBorderColor = new Label(wNoteFontComp, 2048);
        this.wBorderColor.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BorderColor.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wBorderColor);
        this.wBorderColor.setEnabled(false);
        FormData fdBorderColor = new FormData();
        fdBorderColor.left = new FormAttachment((Control)wlBorderColor, margin);
        fdBorderColor.top = new FormAttachment((Control)this.wBackGroundColor, 2 * margin);
        fdBorderColor.right = new FormAttachment((Control)wbBorderColorChange, -margin);
        this.wBorderColor.setLayoutData((Object)fdBorderColor);
        FormData fdNoteFontComp = new FormData();
        fdNoteFontComp.left = new FormAttachment(0, 0);
        fdNoteFontComp.top = new FormAttachment(0, 0);
        fdNoteFontComp.right = new FormAttachment(100, 0);
        fdNoteFontComp.bottom = new FormAttachment(100, 0);
        wNoteFontComp.setLayoutData((Object)fdNoteFontComp);
        wNoteFontComp.layout();
        wNoteFontTab.setControl((Control)wNoteFontComp);
        FormData fdNoteFolder = new FormData();
        fdNoteFolder.left = new FormAttachment(0, 0);
        fdNoteFolder.top = new FormAttachment(0, margin);
        fdNoteFolder.right = new FormAttachment(100, 0);
        fdNoteFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wNoteFolder.setLayoutData((Object)fdNoteFolder);
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.notePadMeta;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.fontColor.dispose();
        this.bgColor.dispose();
        this.borderColor.dispose();
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
        }
        this.shell.dispose();
    }

    public void getData() {
        if (this.notePadMeta != null) {
            this.wDesc.setText(Const.NVL((String)this.notePadMeta.getNote(), (String)""));
            this.wFontName.setText(this.notePadMeta.getFontName() == null ? this.props.getNoteFont().getName() : this.notePadMeta.getFontName());
            this.wFontSize.setSelection(this.notePadMeta.getFontSize() == -1 ? this.props.getNoteFont().getHeight() : this.notePadMeta.getFontSize());
            this.wFontBold.setSelection(this.notePadMeta.isFontBold());
            this.wFontItalic.setSelection(this.notePadMeta.isFontItalic());
            this.fontColor = new Color((Device)this.shell.getDisplay(), this.props.contrastColor(this.notePadMeta.getFontColorRed(), this.notePadMeta.getFontColorGreen(), this.notePadMeta.getFontColorBlue()));
            this.bgColor = new Color((Device)this.shell.getDisplay(), this.props.contrastColor(this.notePadMeta.getBackGroundColorRed(), this.notePadMeta.getBackGroundColorGreen(), this.notePadMeta.getBackGroundColorBlue()));
            this.borderColor = new Color((Device)this.shell.getDisplay(), this.props.contrastColor(this.notePadMeta.getBorderColorRed(), this.notePadMeta.getBorderColorGreen(), this.notePadMeta.getBorderColorBlue()));
        } else {
            this.wFontName.setText(this.props.getNoteFont().getName());
            this.wFontSize.setSelection(this.props.getNoteFont().getHeight());
            this.wFontBold.setSelection(false);
            this.wFontItalic.setSelection(false);
            this.fontColor = new Color((Device)this.shell.getDisplay(), this.props.contrastColor(14, 58, 90));
            this.bgColor = new Color((Device)this.shell.getDisplay(), this.props.contrastColor(201, 232, 251));
            this.borderColor = new Color((Device)this.shell.getDisplay(), this.props.contrastColor(14, 58, 90));
        }
        this.wFontColor.setBackground(this.fontColor);
        this.wBackGroundColor.setBackground(this.bgColor);
        this.wBorderColor.setBackground(this.borderColor);
        this.wNoteFolder.setSelection(0);
        this.wDesc.setFocus();
        this.wDesc.setSelection(this.wDesc.getText().length());
        this.refreshTextNote();
    }

    private void cancel() {
        this.notePadMeta = null;
        this.dispose();
    }

    private void ok() {
        this.notePadMeta = new NotePadMeta();
        if (this.wDesc.getText() != null) {
            this.notePadMeta.setNote(this.wDesc.getText());
        }
        if (this.wFontName.getText() != null) {
            this.notePadMeta.setFontName(this.wFontName.getText());
        }
        this.notePadMeta.setFontSize(this.wFontSize.getSelection());
        this.notePadMeta.setFontBold(this.wFontBold.getSelection());
        this.notePadMeta.setFontItalic(this.wFontItalic.getSelection());
        this.notePadMeta.setFontColorRed(this.wFontColor.getBackground().getRed());
        this.notePadMeta.setFontColorGreen(this.wFontColor.getBackground().getGreen());
        this.notePadMeta.setFontColorBlue(this.wFontColor.getBackground().getBlue());
        this.notePadMeta.setBackGroundColorRed(this.wBackGroundColor.getBackground().getRed());
        this.notePadMeta.setBackGroundColorGreen(this.wBackGroundColor.getBackground().getGreen());
        this.notePadMeta.setBackGroundColorBlue(this.wBackGroundColor.getBackground().getBlue());
        this.notePadMeta.setBorderColorRed(this.wBorderColor.getBackground().getRed());
        this.notePadMeta.setBorderColorGreen(this.wBorderColor.getBackground().getGreen());
        this.notePadMeta.setBorderColorBlue(this.wBorderColor.getBackground().getBlue());
        this.dispose();
    }

    private void refreshTextNote() {
        int swt = 0;
        if (this.wFontBold.getSelection()) {
            swt = 1;
        }
        if (this.wFontItalic.getSelection()) {
            swt |= 2;
        }
        Font oldFont = this.font;
        this.font = new Font((Device)this.shell.getDisplay(), this.wFontName.getText(), this.wFontSize.getSelection(), swt);
        this.wDesc.setFont(this.font);
        if (oldFont != null && !oldFont.isDisposed()) {
            oldFont.dispose();
        }
        for (Control control : this.wDesc.getChildren()) {
            control.setBackground(this.bgColor);
        }
        this.wFontColor.setBackground(this.fontColor);
        this.wBackGroundColor.setBackground(this.bgColor);
        this.wBorderColor.setBackground(this.borderColor);
    }
}

