/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.graph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Ordering;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.graph.ElementOrder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.graph.EndpointPair;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.graph.Graphs;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.graph.MutableNetwork;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.graph.Network;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.graph.NetworkBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Networks {
    public static <NodeT, EdgeT> void replaceDirectedNetworkNodes(@UnknownKeyFor @NonNull @Initialized MutableNetwork<NodeT, EdgeT> network, @UnknownKeyFor @NonNull @Initialized Function<NodeT, NodeT> function) {
        Preconditions.checkArgument((boolean)network.isDirected(), (String)"Only directed networks are supported, given %s", network);
        Preconditions.checkArgument((!network.allowsSelfLoops() ? 1 : 0) != 0, (String)"Only networks without self loops are supported, given %s", network);
        HashMap oldNodesToNewNodes = new HashMap(network.nodes().size());
        for (Object e : network.nodes()) {
            NodeT newNode;
            if (e.equals(newNode = function.apply(e))) continue;
            oldNodesToNewNodes.put(e, newNode);
        }
        for (Map.Entry entry : oldNodesToNewNodes.entrySet()) {
            Object oldNode = entry.getKey();
            Object newNode = entry.getValue();
            network.addNode(newNode);
            for (Object predecessor : ImmutableSet.copyOf((Collection)network.predecessors(oldNode))) {
                for (Object edge : ImmutableSet.copyOf((Collection)network.edgesConnecting(predecessor, oldNode))) {
                    network.removeEdge(edge);
                    network.addEdge(predecessor, newNode, edge);
                }
            }
            for (Object successor : ImmutableSet.copyOf((Collection)network.successors(oldNode))) {
                for (Object edge : ImmutableSet.copyOf((Collection)network.edgesConnecting(oldNode, successor))) {
                    network.removeEdge(edge);
                    network.addEdge(newNode, successor, edge);
                }
            }
            network.removeNode(oldNode);
        }
    }

    public static <NodeT, EdgeT> @UnknownKeyFor @NonNull @Initialized Set<NodeT> reachableNodes(@UnknownKeyFor @NonNull @Initialized Network<NodeT, EdgeT> network, @UnknownKeyFor @NonNull @Initialized Set<NodeT> startNodes, @UnknownKeyFor @NonNull @Initialized Set<NodeT> endNodes) {
        HashSet visitedNodes = new HashSet();
        ArrayDeque<NodeT> queuedNodes = new ArrayDeque<NodeT>();
        queuedNodes.addAll(startNodes);
        while (!queuedNodes.isEmpty()) {
            Object currentNode = queuedNodes.remove();
            if (!visitedNodes.add(currentNode) || endNodes.contains(currentNode)) continue;
            queuedNodes.addAll(network.successors(currentNode));
        }
        return visitedNodes;
    }

    public static <NodeT> @UnknownKeyFor @NonNull @Initialized Iterable<NodeT> topologicalOrder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Network<NodeT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> network) {
        return Networks.computeTopologicalOrder(Graphs.copyOf(network));
    }

    public static <NodeT, EdgeT> @UnknownKeyFor @NonNull @Initialized Iterable<NodeT> topologicalOrder(@UnknownKeyFor @NonNull @Initialized Network<NodeT, EdgeT> network, @UnknownKeyFor @NonNull @Initialized Comparator<NodeT> nodeOrder) {
        MutableNetwork orderedNetwork = NetworkBuilder.from(network).nodeOrder(ElementOrder.sorted(nodeOrder)).build();
        for (Object node : network.nodes()) {
            orderedNetwork.addNode(node);
        }
        for (Object edge : network.edges()) {
            EndpointPair incident = network.incidentNodes(edge);
            orderedNetwork.addEdge(incident.source(), incident.target(), edge);
        }
        return Networks.computeTopologicalOrder(orderedNetwork);
    }

    private static <NodeT> @UnknownKeyFor @NonNull @Initialized Iterable<NodeT> computeTopologicalOrder(final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MutableNetwork<NodeT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> network) {
        Preconditions.checkArgument((boolean)network.isDirected(), (String)"Only directed networks are supported, given %s", network);
        Preconditions.checkArgument((!network.allowsSelfLoops() ? 1 : 0) != 0, (String)"Only networks without self loops are supported, given %s", network);
        ArrayDeque<Object> s1 = new ArrayDeque<Object>();
        ArrayDeque s2 = new ArrayDeque();
        Ordering maximumOrdering = new Ordering<NodeT>(){

            @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
            public @UnknownKeyFor @NonNull @Initialized int compare(@Nonnull @NonNull NodeT t0, @Nonnull @NonNull NodeT t1) {
                return network.outDegree(t0) - network.inDegree(t0) - (network.outDegree(t1) - network.inDegree(t1));
            }
        };
        while (!network.nodes().isEmpty()) {
            boolean nodeRemoved;
            do {
                nodeRemoved = false;
                for (Object possibleSink : ImmutableList.copyOf((Collection)network.nodes())) {
                    if (network.outDegree(possibleSink) != 0) continue;
                    network.removeNode(possibleSink);
                    s2.addFirst(possibleSink);
                    nodeRemoved = true;
                }
            } while (nodeRemoved);
            do {
                nodeRemoved = false;
                for (Object possibleSource : ImmutableList.copyOf((Collection)network.nodes())) {
                    if (network.inDegree(possibleSource) != 0) continue;
                    network.removeNode(possibleSource);
                    s1.addLast(possibleSource);
                    nodeRemoved = true;
                }
            } while (nodeRemoved);
            if (network.nodes().isEmpty()) continue;
            Object maximum = maximumOrdering.max((Iterable)network.nodes());
            network.removeNode(maximum);
            s1.addLast(maximum);
        }
        return ImmutableList.builder().addAll(s1).addAll(s2).build();
    }

    public static <NodeT, EdgeT> @UnknownKeyFor @NonNull @Initialized String toDot(@UnknownKeyFor @NonNull @Initialized Network<NodeT, EdgeT> network) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("digraph network {%n", new Object[0]));
        IdentityHashMap nodeName = Maps.newIdentityHashMap();
        network.nodes().forEach(node -> nodeName.put(node, "n" + nodeName.size()));
        for (Map.Entry nodeEntry : nodeName.entrySet()) {
            builder.append(String.format("  %s [fontname=\"Courier New\" label=\"%s\"];%n", nodeEntry.getValue(), Networks.escapeDot(nodeEntry.getKey().toString())));
        }
        for (Map.Entry edge : network.edges()) {
            EndpointPair endpoints = network.incidentNodes(edge);
            builder.append(String.format("  %s -> %s [fontname=\"Courier New\" label=\"%s\"];%n", nodeName.get(endpoints.source()), nodeName.get(endpoints.target()), Networks.escapeDot(edge.toString())));
        }
        builder.append("}");
        return builder.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String escapeDot(@UnknownKeyFor @NonNull @Initialized String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\l");
    }

    public static <NodeT, EdgeT> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<NodeT>> allPathsFromRootsToLeaves(@UnknownKeyFor @NonNull @Initialized Network<NodeT, EdgeT> network) {
        ArrayDeque<ImmutableList> paths = new ArrayDeque<ImmutableList>();
        for (Object node : network.nodes()) {
            if (network.inDegree(node) != 0) continue;
            paths.add(ImmutableList.of(node));
        }
        ArrayList<List<NodeT>> distinctPathsFromRootsToLeaves = new ArrayList<List<NodeT>>();
        while (!paths.isEmpty()) {
            List path = (List)paths.removeFirst();
            Object lastNode = path.get(path.size() - 1);
            if (network.outDegree(lastNode) == 0) {
                distinctPathsFromRootsToLeaves.add(new ArrayList(path));
                continue;
            }
            for (Object edge : network.outEdges(lastNode)) {
                paths.addFirst(ImmutableList.builder().addAll((Iterable)path).add(network.incidentNodes(edge).target()).build());
            }
        }
        return distinctPathsFromRootsToLeaves;
    }

    private Networks() {
    }

    public static abstract class TypeSafeNodeFunction<@UnknownKeyFor NodeT, @UnknownKeyFor T extends NodeT>
    implements Function<NodeT, NodeT> {
        private final @UnknownKeyFor @NonNull @Initialized Class<T> type;

        public TypeSafeNodeFunction(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
            Preconditions.checkNotNull(type);
            this.type = type;
        }

        @Override
        public final NodeT apply(NodeT input) {
            if (this.type.isInstance(input)) {
                return this.typedApply(input);
            }
            return input;
        }

        public abstract NodeT typedApply(T var1);
    }
}

