/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.HighlyCompressedMapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.Utils$;
import org.roaringbitmap.RoaringBitmap;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class HighlyCompressedMapStatus$
implements scala.Serializable {
    public static HighlyCompressedMapStatus$ MODULE$;

    static {
        new HighlyCompressedMapStatus$();
    }

    public HighlyCompressedMapStatus apply(BlockManagerId loc, long[] uncompressedSizes, long mapTaskId) {
        double d;
        int i = 0;
        int numNonEmptyBlocks = 0;
        int numSmallBlocks = 0;
        long totalSmallBlockSize = 0L;
        RoaringBitmap emptyBlocks = new RoaringBitmap();
        int totalNumBlocks = uncompressedSizes.length;
        double accurateBlockSkewedFactor = BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)HighlyCompressedMapStatus$.$anonfun$apply$1(x$3))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToDouble((Object)package$.MODULE$.SHUFFLE_ACCURATE_BLOCK_SKEWED_FACTOR().defaultValue().get())));
        long shuffleAccurateBlockThreshold = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)HighlyCompressedMapStatus$.$anonfun$apply$3(x$4))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)package$.MODULE$.SHUFFLE_ACCURATE_BLOCK_THRESHOLD().defaultValue().get())));
        if (accurateBlockSkewedFactor > 0.0) {
            long[] sortedSizes = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(uncompressedSizes)).sorted((Ordering)Ordering.Long$.MODULE$);
            long medianSize = Utils$.MODULE$.median(sortedSizes, true);
            int maxAccurateSkewedBlockNumber = Math.min(BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)HighlyCompressedMapStatus$.$anonfun$apply$5(x$5))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)package$.MODULE$.SHUFFLE_MAX_ACCURATE_SKEWED_BLOCK_NUMBER().defaultValue().get()))), totalNumBlocks);
            double skewSizeThreshold = Math.max((double)medianSize * accurateBlockSkewedFactor, (double)sortedSizes[totalNumBlocks - maxAccurateSkewedBlockNumber]);
            d = Math.min((double)shuffleAccurateBlockThreshold, skewSizeThreshold);
        } else {
            d = shuffleAccurateBlockThreshold;
        }
        double threshold = d;
        scala.collection.mutable.Map hugeBlockSizes = Map$.MODULE$.empty();
        while (i < totalNumBlocks) {
            long size = uncompressedSizes[i];
            if (size > 0L) {
                ++numNonEmptyBlocks;
                if ((double)size < threshold) {
                    totalSmallBlockSize += size;
                    ++numSmallBlocks;
                } else {
                    hugeBlockSizes.update((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToByte((byte)MapStatus$.MODULE$.compressSize(uncompressedSizes[i])));
                }
            } else {
                emptyBlocks.add(i);
            }
            ++i;
        }
        long avgSize = numSmallBlocks > 0 ? totalSmallBlockSize / (long)numSmallBlocks : 0L;
        emptyBlocks.trim();
        emptyBlocks.runOptimize();
        return new HighlyCompressedMapStatus(loc, numNonEmptyBlocks, emptyBlocks, avgSize, (Map<Object, Object>)hugeBlockSizes, mapTaskId);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ double $anonfun$apply$1(SparkEnv x$3) {
        return BoxesRunTime.unboxToDouble((Object)x$3.conf().get(package$.MODULE$.SHUFFLE_ACCURATE_BLOCK_SKEWED_FACTOR()));
    }

    public static final /* synthetic */ long $anonfun$apply$3(SparkEnv x$4) {
        return BoxesRunTime.unboxToLong((Object)x$4.conf().get(package$.MODULE$.SHUFFLE_ACCURATE_BLOCK_THRESHOLD()));
    }

    public static final /* synthetic */ int $anonfun$apply$5(SparkEnv x$5) {
        return BoxesRunTime.unboxToInt((Object)x$5.conf().get(package$.MODULE$.SHUFFLE_MAX_ACCURATE_SKEWED_BLOCK_NUMBER()));
    }

    private HighlyCompressedMapStatus$() {
        MODULE$ = this;
    }
}

