/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca;

import com.googlecode.jsendnsca.Level;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.utils.ByteArrayUtils;
import java.util.zip.CRC32;

class PassiveCheckBytesBuilder {
    private static final short NSCA_VERSION = 3;
    private static final int HOST_NAME_SIZE = 64;
    private static final int SERVICE_NAME_SIZE = 128;
    private final byte[] bytes;
    private int currentOffset;
    private final NagiosSettings nagiosSettings;

    PassiveCheckBytesBuilder(NagiosSettings nagiosSettings) {
        this.nagiosSettings = nagiosSettings;
        this.bytes = new byte[208 + nagiosSettings.getMaxMessageSizeInChars()];
        ByteArrayUtils.writeShort(this.bytes, (short)3, this.currentOffset);
        this.currentOffset += 8;
    }

    public PassiveCheckBytesBuilder withLevel(Level level) {
        ByteArrayUtils.writeShort(this.bytes, (short)level.ordinal(), this.currentOffset);
        this.currentOffset += 2;
        return this;
    }

    public PassiveCheckBytesBuilder withTimeStamp(int value) {
        ByteArrayUtils.writeInteger(this.bytes, value, this.currentOffset);
        this.currentOffset += 4;
        return this;
    }

    public PassiveCheckBytesBuilder withHostname(String hostname) {
        this.writeFixedString(hostname, 63);
        this.skipOneByte();
        return this;
    }

    public PassiveCheckBytesBuilder withServiceName(String serviceName) {
        this.writeFixedString(serviceName, 127);
        this.skipOneByte();
        return this;
    }

    public PassiveCheckBytesBuilder withMessage(String message) {
        this.writeFixedString(message, this.nagiosSettings.getMaxMessageSizeInChars() - 1);
        this.skipOneByte();
        return this;
    }

    private void skipOneByte() {
        ++this.currentOffset;
    }

    public PassiveCheckBytesBuilder writeCRC() {
        CRC32 crc = new CRC32();
        crc.update(this.bytes);
        ByteArrayUtils.writeInteger(this.bytes, (int)crc.getValue(), 4);
        return this;
    }

    public byte[] toByteArray() {
        return this.bytes;
    }

    public PassiveCheckBytesBuilder encrypt(byte[] initVector) {
        this.nagiosSettings.getEncryptor().encrypt(this.bytes, initVector, this.nagiosSettings.getPassword());
        return this;
    }

    private void writeFixedString(String value, int fixedSize) {
        ByteArrayUtils.writeFixedString(this.bytes, value, this.currentOffset, fixedSize);
        this.currentOffset += fixedSize;
    }
}

