/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_SplittingIterable_Value;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

class SplittingIterable
implements Iterable<Value> {
    private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlying;
    private final @UnknownKeyFor @NonNull @Initialized long splitSize;
    private final @UnknownKeyFor @NonNull @Initialized ConvertUnknownFields unknownFieldsToMessage;
    private final @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized TableRow> protoToTableRow;
    private final @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized TimestampedValue<@UnknownKeyFor @NonNull @Initialized TableRow>, @UnknownKeyFor @NonNull @Initialized String> failedRowsConsumer;
    private final @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema;
    private final @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues;
    private final @UnknownKeyFor @NonNull @Initialized Instant elementsTimestamp;

    public SplittingIterable(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlying, @UnknownKeyFor @NonNull @Initialized long splitSize, @UnknownKeyFor @NonNull @Initialized ConvertUnknownFields unknownFieldsToMessage, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized TableRow> protoToTableRow, @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized TimestampedValue<@UnknownKeyFor @NonNull @Initialized TableRow>, @UnknownKeyFor @NonNull @Initialized String> failedRowsConsumer, @UnknownKeyFor @NonNull @Initialized boolean autoUpdateSchema, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized Instant elementsTimestamp) {
        this.underlying = underlying;
        this.splitSize = splitSize;
        this.unknownFieldsToMessage = unknownFieldsToMessage;
        this.protoToTableRow = protoToTableRow;
        this.failedRowsConsumer = failedRowsConsumer;
        this.autoUpdateSchema = autoUpdateSchema;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.elementsTimestamp = elementsTimestamp;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Value> iterator() {
        return new Iterator<Value>(){
            final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> underlyingIterator;
            {
                this.underlyingIterator = SplittingIterable.this.underlying.iterator();
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
                return this.underlyingIterator.hasNext();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Value next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArrayList timestamps = Lists.newArrayList();
                ProtoRows.Builder inserts = ProtoRows.newBuilder();
                long bytesSize = 0L;
                while (this.underlyingIterator.hasNext()) {
                    ByteString byteString;
                    StorageApiWritePayload payload;
                    block9: {
                        payload = this.underlyingIterator.next();
                        byteString = ByteString.copyFrom((byte[])payload.getPayload());
                        if (SplittingIterable.this.autoUpdateSchema) {
                            try {
                                @Nullable TableRow unknownFields = payload.getUnknownFields();
                                if (unknownFields == null || unknownFields.isEmpty()) break block9;
                                try {
                                    byteString = byteString.concat(SplittingIterable.this.unknownFieldsToMessage.convert(unknownFields, SplittingIterable.this.ignoreUnknownValues));
                                }
                                catch (TableRowToStorageApiProto.SchemaConversionException e) {
                                    TableRow tableRow = (TableRow)SplittingIterable.this.protoToTableRow.apply(byteString);
                                    Instant timestamp = payload.getTimestamp();
                                    if (timestamp == null) {
                                        timestamp = SplittingIterable.this.elementsTimestamp;
                                    }
                                    SplittingIterable.this.failedRowsConsumer.accept(TimestampedValue.of((Object)tableRow, (Instant)timestamp), e.toString());
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    inserts.addSerializedRows(byteString);
                    Instant timestamp = payload.getTimestamp();
                    if (timestamp == null) {
                        timestamp = SplittingIterable.this.elementsTimestamp;
                    }
                    timestamps.add(timestamp);
                    if ((bytesSize += (long)byteString.size()) <= SplittingIterable.this.splitSize) continue;
                    break;
                }
                return new AutoValue_SplittingIterable_Value(inserts.build(), timestamps);
            }
        };
    }

    static interface ConvertUnknownFields {
        public @UnknownKeyFor @NonNull @Initialized ByteString convert(@UnknownKeyFor @NonNull @Initialized TableRow var1, @UnknownKeyFor @NonNull @Initialized boolean var2) throws  @UnknownKeyFor @NonNull @Initialized TableRowToStorageApiProto.SchemaConversionException;
    }

    @AutoValue
    static abstract class Value {
        Value() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized ProtoRows getProtoRows();

        abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Instant> getTimestamps();
    }
}

