/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.shared.VariableValue;
import org.apache.hop.beam.core.transform.TransformFn;
import org.apache.hop.beam.core.util.HopBeamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformTransform
extends PTransform<PCollection<HopRow>, PCollectionTuple> {
    protected List<VariableValue> variableValues;
    protected String metastoreJson;
    protected int batchSize;
    protected String transformName;
    protected String transformPluginId;
    protected String inputRowMetaJson;
    protected boolean inputTransform;
    protected String transformMetaInterfaceXml;
    protected List<String> targetTransforms;
    protected List<String> infoTransforms;
    protected List<String> infoRowMetaJsons;
    protected int flushIntervalMs;
    protected String runConfigName;
    protected String dataSamplersJson;
    protected String parentLogChannelId;
    protected List<PCollectionView<List<HopRow>>> infoCollectionViews;
    protected static final Logger LOG = LoggerFactory.getLogger(TransformTransform.class);
    protected static final Counter numErrors = Metrics.counter((String)"main", (String)"TransformErrors");

    public TransformTransform() {
        this.variableValues = new ArrayList<VariableValue>();
    }

    public TransformTransform(List<VariableValue> variableValues, String metastoreJson, int batchSize, int flushIntervalMs, String transformName, String transformPluginId, String transformMetaInterfaceXml, String inputRowMetaJson, boolean inputTransform, List<String> targetTransforms, List<String> infoTransforms, List<String> infoRowMetaJsons, List<PCollectionView<List<HopRow>>> infoCollectionViews, String runConfigName, String dataSamplersJson, String parentLogChannelId) {
        this.variableValues = variableValues;
        this.metastoreJson = metastoreJson;
        this.batchSize = batchSize;
        this.flushIntervalMs = flushIntervalMs;
        this.transformName = transformName;
        this.transformPluginId = transformPluginId;
        this.transformMetaInterfaceXml = transformMetaInterfaceXml;
        this.inputRowMetaJson = inputRowMetaJson;
        this.inputTransform = inputTransform;
        this.targetTransforms = targetTransforms;
        this.infoTransforms = infoTransforms;
        this.infoRowMetaJsons = infoRowMetaJsons;
        this.infoCollectionViews = infoCollectionViews;
        this.runConfigName = runConfigName;
        this.dataSamplersJson = dataSamplersJson;
        this.parentLogChannelId = parentLogChannelId;
    }

    public PCollectionTuple expand(PCollection<HopRow> input) {
        try {
            BeamHop.init();
            TupleTag<HopRow> mainOutputTupleTag = new TupleTag<HopRow>(HopBeamUtil.createMainOutputTupleId(this.transformName)){};
            TupleTagList targetTupleTagList = null;
            for (String targetTransform : this.targetTransforms) {
                String tupleId = HopBeamUtil.createTargetTupleId(this.transformName, targetTransform);
                TupleTag<HopRow> tupleTag = new TupleTag<HopRow>(tupleId){};
                if (targetTupleTagList == null) {
                    targetTupleTagList = TupleTagList.of((TupleTag)tupleTag);
                    continue;
                }
                targetTupleTagList = targetTupleTagList.and((TupleTag)tupleTag);
            }
            if (targetTupleTagList == null) {
                targetTupleTagList = TupleTagList.empty();
            }
            TransformFn transformFn = new TransformFn(this.variableValues, this.metastoreJson, this.transformName, this.transformPluginId, this.transformMetaInterfaceXml, this.inputRowMetaJson, this.inputTransform, this.targetTransforms, this.infoTransforms, this.infoRowMetaJsons, this.dataSamplersJson, this.runConfigName, this.parentLogChannelId, this.infoCollectionViews);
            ParDo.SingleOutput parDoTransformFn = ParDo.of((DoFn)transformFn);
            if (this.infoCollectionViews.size() > 0) {
                parDoTransformFn = parDoTransformFn.withSideInputs(this.infoCollectionViews);
            }
            ParDo.MultiOutput multiOutput = parDoTransformFn.withOutputTags((TupleTag)mainOutputTupleTag, targetTupleTagList);
            PCollectionTuple collectionTuple = (PCollectionTuple)input.apply((PTransform)multiOutput);
            return collectionTuple;
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error transforming data in transform '" + this.transformName + "'", (Throwable)e);
            throw new RuntimeException("Error transforming data in transform", e);
        }
    }
}

