/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.SparkCommonPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.translation.EvaluationContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.SparkTransformOverrides;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.SideInputValues;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderProvider;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.storage.StorageLevel;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.reflect.ClassTag;

@Internal
public abstract class PipelineTranslator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PipelineTranslator.class);
    private static final @UnknownKeyFor @NonNull @Initialized int PLAN_COMPLEXITY_THRESHOLD = 6;

    public static void replaceTransforms(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingOptions options) {
        pipeline.replaceAll(SparkTransformOverrides.getDefaultOverrides(options.isStreaming()));
    }

    public static void detectStreamingMode(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized StreamingOptions options) {
        StreamingModeDetector detector = new StreamingModeDetector(options.isStreaming());
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)detector);
        options.setStreaming(detector.streaming);
    }

    @javax.annotation.Nullable
    protected abstract <InT extends PInput, OutT extends POutput, TransformT extends PTransform<InT, OutT>> @UnknownKeyFor @Nullable @Initialized TransformTranslator<InT, OutT, TransformT> getTransformTranslator(TransformT var1);

    public @UnknownKeyFor @NonNull @Initialized EvaluationContext translate(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkSession session, @UnknownKeyFor @NonNull @Initialized SparkCommonPipelineOptions options) {
        LOG.debug("starting translation of the pipeline using {}", (Object)this.getClass().getName());
        DependencyVisitor dependencies = new DependencyVisitor();
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)dependencies);
        TranslatingVisitor translator = new TranslatingVisitor(session, options, dependencies.results);
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)translator);
        return new EvaluationContext(translator.leaves, session);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Broadcast<T> broadcast(@UnknownKeyFor @NonNull @Initialized SparkSession session, T t) {
        return session.sparkContext().broadcast(t, ClassTag.AnyRef());
    }

    private static class StreamingModeDetector
    extends Pipeline.PipelineVisitor.Defaults {
        private @UnknownKeyFor @NonNull @Initialized boolean streaming;

        StreamingModeDetector(@UnknownKeyFor @NonNull @Initialized boolean streaming) {
            this.streaming = streaming;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            return this.streaming ? Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM : Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
            if (value instanceof PCollection && ((PCollection)value).isBounded() == PCollection.IsBounded.UNBOUNDED) {
                LOG.info("Found unbounded PCollection {}, switching to streaming mode.", (Object)value.getName());
                this.streaming = true;
            }
        }
    }

    private abstract class PTransformVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private PTransformVisitor() {
        }

        abstract <InT extends PInput, OutT extends POutput> void visit(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node var1, @UnknownKeyFor @NonNull @Initialized PTransform<InT, OutT> var2, @UnknownKeyFor @NonNull @Initialized TransformTranslator<InT, OutT, @UnknownKeyFor @NonNull @Initialized PTransform<InT, OutT>> var3);

        public final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            PTransform transform = node.getTransform();
            TransformTranslator<PInput, POutput, PTransform<PInput, POutput>> translator = this.getSupportedTranslator((PTransform<PInput, POutput>)transform);
            if (transform != null && translator != null) {
                this.visit(node, transform, translator);
                return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        public final void visitPrimitiveTransform(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            PTransform transform = node.getTransform();
            if (transform == null || transform.getClass().equals(View.CreatePCollectionView.class)) {
                return;
            }
            TransformTranslator<PInput, POutput, PTransform<PInput, POutput>> translator = this.getSupportedTranslator((PTransform<PInput, POutput>)transform);
            if (translator == null) {
                String urn = PTransformTranslation.urnForTransform((PTransform)transform);
                throw new UnsupportedOperationException("Transform " + urn + " is not supported.");
            }
            this.visit(node, transform, translator);
        }

        @javax.annotation.Nullable
        private @UnknownKeyFor @Nullable @Initialized TransformTranslator<@UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor @NonNull @Initialized POutput, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor @NonNull @Initialized POutput>> getSupportedTranslator(@javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PInput, @UnknownKeyFor @NonNull @Initialized POutput> transform) {
            if (transform == null) {
                return null;
            }
            TransformTranslator translator = PipelineTranslator.this.getTransformTranslator(transform);
            return translator != null && translator.canTranslate(transform) ? translator : null;
        }
    }

    private class DependencyVisitor
    extends PTransformVisitor {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized TranslationResult<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> results = new HashMap();

        private DependencyVisitor() {
        }

        @Override
        <InT extends PInput, OutT extends POutput> void visit(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, @UnknownKeyFor @NonNull @Initialized PTransform<InT, OutT> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator<InT, OutT, @UnknownKeyFor @NonNull @Initialized PTransform<InT, OutT>> translator) {
            ArrayList<TranslationResult> dependencies = new ArrayList<TranslationResult>(node.getInputs().size());
            for (Map.Entry entry : node.getInputs().entrySet()) {
                TranslationResult input = (TranslationResult)Preconditions.checkStateNotNull(this.results.get(entry.getValue()));
                dependencies.add(input);
                input.dependentTransforms.add(transform);
            }
            for (PCollection pOut : node.getOutputs().values()) {
                this.results.put(pOut, new TranslationResult(pOut, translator.complexityFactor, dependencies));
            }
        }
    }

    private static class BroadcastOptions
    implements Supplier<PipelineOptions>,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions> broadcast;

        private BroadcastOptions(@UnknownKeyFor @NonNull @Initialized SparkSession session, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.broadcast = PipelineTranslator.broadcast(session, new SerializablePipelineOptions(options));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PipelineOptions get() {
            return ((SerializablePipelineOptions)this.broadcast.value()).get();
        }
    }

    private class TranslatingVisitor
    extends PTransformVisitor
    implements TranslationState {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized TranslationResult<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> translationResults;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> encoders;
        private final @UnknownKeyFor @NonNull @Initialized SparkSession sparkSession;
        private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> optionsSupplier;
        private final @UnknownKeyFor @NonNull @Initialized StorageLevel storageLevel;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TranslationResult<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> leaves;

        public TranslatingVisitor(@UnknownKeyFor @NonNull @Initialized SparkSession sparkSession, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized SparkCommonPipelineOptions options, Map<PCollection<?>, TranslationResult<?, ?>> translationResults) {
            this.sparkSession = sparkSession;
            this.translationResults = translationResults;
            this.options = options;
            this.optionsSupplier = new BroadcastOptions(sparkSession, options);
            this.storageLevel = StorageLevel.fromString((String)options.getStorageLevel());
            this.encoders = new HashMap();
            this.leaves = new HashSet();
        }

        @Override
        <InT extends PInput, OutT extends POutput> void visit(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node, @UnknownKeyFor @NonNull @Initialized PTransform<InT, OutT> transform, @UnknownKeyFor @NonNull @Initialized TransformTranslator<InT, OutT, @UnknownKeyFor @NonNull @Initialized PTransform<InT, OutT>> translator) {
            AppliedPTransform appliedTransform = node.toAppliedPTransform(this.getPipeline());
            try {
                LOG.info("Translating {}: {}", (Object)(node.isCompositeNode() ? "composite" : "primitive"), (Object)node.getFullName());
                translator.translate(transform, appliedTransform, this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized Encoder<T> encoderOf(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized EncoderProvider.Factory<T> factory) {
            Encoder enc = this.encoders.get(coder);
            if (enc == null) {
                enc = (Encoder)factory.apply(coder);
                this.encoders.put(coder, enc);
            }
            return enc;
        }

        private <IntT, T> @UnknownKeyFor @NonNull @Initialized TranslationResult<IntT, T> getResult(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection) {
            return (TranslationResult)Preconditions.checkStateNotNull(this.translationResults.get(pCollection));
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getDataset(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection) {
            return this.getOrResolve(this.getResult(pCollection));
        }

        @Override
        public <T> void putDataset(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> dataset, @UnknownKeyFor @NonNull @Initialized boolean cache) {
            TranslationResult result = this.getResult(pCollection);
            result.dataset = dataset;
            if (cache && result.usages() > 1) {
                LOG.info("Dataset {} will be cached for reuse.", (Object)result.name);
                dataset.persist(this.storageLevel);
            }
            if (result.estimatePlanComplexity() > 6.0f) {
                LOG.info("Breaking linage of dataset {} to limit complexity of query plan.", (Object)result.name);
                result.dataset = this.sparkSession.createDataset(dataset.rdd(), dataset.encoder());
                result.resetPlanComplexity();
            }
            if (result.isLeaf()) {
                this.leaves.add(result);
            }
        }

        private <InT, T> @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getOrResolve(@UnknownKeyFor @NonNull @Initialized TranslationResult<InT, T> result) {
            UnresolvedTranslation unresolved = ((TranslationResult)result).unresolved;
            if (unresolved != null) {
                ((TranslationResult)result).dataset = unresolved.resolve(this.optionsSupplier, this.getDataset(unresolved.getInput()));
                ((TranslationResult)result).unresolved = null;
            }
            return (Dataset)Preconditions.checkStateNotNull((Object)((TranslationResult)result).dataset);
        }

        public <InT, T> void putUnresolved(@UnknownKeyFor @NonNull @Initialized PCollection<T> out, @UnknownKeyFor @NonNull @Initialized UnresolvedTranslation<InT, T> unresolved) {
            TranslationResult translIn = this.getResult(unresolved.getInput());
            TranslationResult translOut = this.getResult(out);
            UnresolvedTranslation unresolvedIn = translIn.unresolved;
            translOut.unresolved = unresolvedIn != null ? unresolvedIn.fuse(unresolved) : unresolved;
            translIn.unresolved = null;
            if (translOut.usages() != 1) {
                this.putDataset(out, this.getOrResolve(translOut));
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isLeaf(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pCollection) {
            return this.getResult(pCollection).isLeaf();
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized SideInputValues<T>> getSideInputBroadcast(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection, @UnknownKeyFor @NonNull @Initialized SideInputValues.Loader<T> loader) {
            TranslationResult result = this.getResult(pCollection);
            if (result.sideInputBroadcast == null) {
                SideInputValues sideInputValues = (SideInputValues)loader.apply(this.getOrResolve(result));
                result.sideInputBroadcast = PipelineTranslator.broadcast(this.sparkSession, sideInputValues);
            }
            return result.sideInputBroadcast;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> getOptionsSupplier() {
            return this.optionsSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PipelineOptions getOptions() {
            return this.options;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized SparkSession getSparkSession() {
            return this.sparkSession;
        }
    }

    public static interface TranslationState
    extends EncoderProvider {
        public <T> @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getDataset(@UnknownKeyFor @NonNull @Initialized PCollection<T> var1);

        public @UnknownKeyFor @NonNull @Initialized boolean isLeaf(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

        public <InT, OutT> void putUnresolved(@UnknownKeyFor @NonNull @Initialized PCollection<OutT> var1, @UnknownKeyFor @NonNull @Initialized UnresolvedTranslation<InT, OutT> var2);

        public <T> void putDataset(@UnknownKeyFor @NonNull @Initialized PCollection<T> var1, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> var2, @UnknownKeyFor @NonNull @Initialized boolean var3);

        default public <T> void putDataset(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> dataset) {
            this.putDataset(pCollection, dataset, true);
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized SideInputValues<T>> getSideInputBroadcast(@UnknownKeyFor @NonNull @Initialized PCollection<T> var1, @UnknownKeyFor @NonNull @Initialized SideInputValues.Loader<T> var2);

        public @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> getOptionsSupplier();

        public @UnknownKeyFor @NonNull @Initialized PipelineOptions getOptions();

        public @UnknownKeyFor @NonNull @Initialized SparkSession getSparkSession();
    }

    public static interface UnresolvedTranslation<@UnknownKeyFor InT, @UnknownKeyFor T> {
        public @UnknownKeyFor @NonNull @Initialized PCollection<InT> getInput();

        public <T2> @UnknownKeyFor @NonNull @Initialized UnresolvedTranslation<InT, T2> fuse(@UnknownKeyFor @NonNull @Initialized UnresolvedTranslation<T, T2> var1);

        public @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> resolve(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> var1, @UnknownKeyFor @NonNull @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>> var2);
    }

    private static final class TranslationResult<@UnknownKeyFor IntT, @UnknownKeyFor T>
    implements EvaluationContext.NamedDataset<T> {
        private final @UnknownKeyFor @NonNull @Initialized String name;
        private final @UnknownKeyFor @NonNull @Initialized float complexityFactor;
        private @UnknownKeyFor @NonNull @Initialized float planComplexity = 0.0f;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> dataset = null;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized SideInputValues<T>> sideInputBroadcast = null;
        @javax.annotation.Nullable
        private @UnknownKeyFor @Nullable @Initialized UnresolvedTranslation<IntT, T> unresolved = null;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> dependentTransforms = new HashSet();
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TranslationResult<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> dependencies;

        private TranslationResult(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pCol, @UnknownKeyFor @NonNull @Initialized float complexityFactor, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TranslationResult<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> dependencies) {
            this.name = pCol.getName();
            this.complexityFactor = complexityFactor;
            this.dependencies = dependencies;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String name() {
            return this.name;
        }

        @Override
        @javax.annotation.Nullable
        public @UnknownKeyFor @Nullable @Initialized Dataset<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> dataset() {
            return this.dataset;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean isLeaf() {
            return this.dependentTransforms.isEmpty();
        }

        private @UnknownKeyFor @NonNull @Initialized int usages() {
            return this.dependentTransforms.size();
        }

        private void resetPlanComplexity() {
            this.planComplexity = 1.0f;
        }

        private @UnknownKeyFor @NonNull @Initialized float estimatePlanComplexity() {
            if (this.planComplexity > 0.0f) {
                return this.planComplexity;
            }
            float complexity = 1.0f + this.complexityFactor;
            for (TranslationResult<?, ?> result : this.dependencies) {
                complexity *= super.estimatePlanComplexity();
            }
            this.planComplexity = complexity;
            return this.planComplexity;
        }
    }
}

