/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type;

import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.CustomType;
import com.datastax.oss.driver.api.core.type.DataType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class CqlVectorType
implements CustomType {
    public static final String CQLVECTOR_CLASS_NAME = "org.apache.cassandra.db.marshal.VectorType";
    private final DataType subtype;
    private final int dimensions;

    public CqlVectorType(DataType subtype, int dimensions) {
        this.dimensions = dimensions;
        this.subtype = subtype;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public DataType getSubtype() {
        return this.subtype;
    }

    @Override
    @NonNull
    public String getClassName() {
        return CQLVECTOR_CLASS_NAME;
    }

    @Override
    @NonNull
    public String asCql(boolean includeFrozen, boolean pretty) {
        return String.format("'%s(%d)'", this.getClassName(), this.getDimensions());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CqlVectorType) {
            CqlVectorType that = (CqlVectorType)o;
            return that.subtype.equals(this.subtype) && that.dimensions == this.dimensions;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subtype, this.dimensions);
    }

    public String toString() {
        return String.format("CqlVector(%s, %d)", this.getSubtype(), this.getDimensions());
    }

    @Override
    public boolean isDetached() {
        return false;
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
    }
}

