/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.googlesheets;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.vfs.HopVfs;

public class GoogleSheetsCredentials {
    public static final String APPLICATION_NAME = "Apache-Hop-Google-Sheets";

    public static HttpCredentialsAdapter getCredentialsJson(String scope, String jsonCredentialPath, String impersonation) throws IOException {
        InputStream in;
        try {
            in = HopVfs.getInputStream((String)jsonCredentialPath);
        }
        catch (HopFileException ex) {
            throw new IOException("Error opening JSON Credentials file " + jsonCredentialPath, ex);
        }
        if (in == null) {
            throw new FileNotFoundException("Resource not found:" + jsonCredentialPath);
        }
        GoogleCredentials credential = StringUtils.isEmpty((String)impersonation) ? GoogleCredentials.fromStream((InputStream)in).createScoped(Collections.singleton(scope)) : GoogleCredentials.fromStream((InputStream)in).createScoped(Collections.singleton("https://www.googleapis.com/auth/sqlservice.admin")).createDelegated(impersonation);
        return new HttpCredentialsAdapter((Credentials)credential);
    }

    public static HttpRequestInitializer setHttpTimeout(final HttpRequestInitializer requestInitializer, final String timeout) {
        return new HttpRequestInitializer(){

            public void initialize(HttpRequest httpRequest) throws IOException {
                Integer TO = Integer.parseInt(timeout);
                requestInitializer.initialize(httpRequest);
                httpRequest.setConnectTimeout(TO * 60000);
                httpRequest.setReadTimeout(TO * 60000);
            }
        };
    }
}

