/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.httppost;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.HttpClientManager;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.httppost.HttpPostData;
import org.apache.hop.pipeline.transforms.httppost.HttpPostMeta;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;

public class HttpPost
extends BaseTransform<HttpPostMeta, HttpPostData> {
    private static final Class<?> PKG = HttpPostMeta.class;
    private static final String CONTENT_TYPE = "Content-type";
    private static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    private static final String PKG_HEADER_VALUE = "HTTPPOST.Log.HeaderValue";
    private static final String PKG_ERROR_FINDING_FIELD = "HTTPPOST.Log.ErrorFindingField";

    public HttpPost(TransformMeta transformMeta, HttpPostMeta meta, HttpPostData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] callHttpPOST(Object[] rowData) throws HopException {
        HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
        if (((HttpPostData)this.data).realConnectionTimeout > -1) {
            clientBuilder.setConnectionTimeout(((HttpPostData)this.data).realConnectionTimeout);
        }
        if (((HttpPostData)this.data).realSocketTimeout > -1) {
            clientBuilder.setSocketTimeout(((HttpPostData)this.data).realSocketTimeout);
        }
        if (StringUtils.isNotBlank((String)((HttpPostData)this.data).realHttpLogin)) {
            clientBuilder.setCredentials(((HttpPostData)this.data).realHttpLogin, ((HttpPostData)this.data).realHttpPassword);
        }
        if (StringUtils.isNotBlank((String)((HttpPostData)this.data).realProxyHost)) {
            clientBuilder.setProxy(((HttpPostData)this.data).realProxyHost, ((HttpPostData)this.data).realProxyPort);
        }
        if (((HttpPostMeta)this.meta).isIgnoreSsl()) {
            clientBuilder.ignoreSsl(true);
        }
        CloseableHttpClient httpClient = clientBuilder.build();
        if (((HttpPostMeta)this.meta).isUrlInField()) {
            ((HttpPostData)this.data).realUrl = ((HttpPostData)this.data).inputRowMeta.getString(rowData, ((HttpPostData)this.data).indexOfUrlField);
        }
        try {
            int i;
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ConnectingToURL", (String[])new String[]{((HttpPostData)this.data).realUrl}));
            }
            URIBuilder uriBuilder = new URIBuilder(((HttpPostData)this.data).realUrl);
            org.apache.http.client.methods.HttpPost post = new org.apache.http.client.methods.HttpPost(uriBuilder.build());
            String bodyParams = null;
            if (!((HttpPostData)this.data).contentTypeHeaderOverwrite && !((HttpPostMeta)this.meta).isPostAFile()) {
                if (Utils.isEmpty((CharSequence)((HttpPostData)this.data).realEncoding)) {
                    post.setHeader(CONTENT_TYPE, CONTENT_TYPE_TEXT_XML);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)PKG_HEADER_VALUE, (String[])new String[]{CONTENT_TYPE, CONTENT_TYPE_TEXT_XML}));
                    }
                } else {
                    post.setHeader(CONTENT_TYPE, "text/xml; " + ((HttpPostData)this.data).realEncoding);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)PKG_HEADER_VALUE, (String[])new String[]{CONTENT_TYPE, "text/xml; " + ((HttpPostData)this.data).realEncoding}));
                    }
                }
            }
            if (((HttpPostData)this.data).useHeaderParameters) {
                for (i = 0; i < ((HttpPostData)this.data).header_parameters_nrs.length; ++i) {
                    post.addHeader(((HttpPostData)this.data).headerParameters[i].getName(), ((HttpPostData)this.data).inputRowMeta.getString(rowData, ((HttpPostData)this.data).header_parameters_nrs[i]));
                    if (!this.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)PKG_HEADER_VALUE, (String[])new String[]{((HttpPostData)this.data).headerParameters[i].getName(), ((HttpPostData)this.data).inputRowMeta.getString(rowData, ((HttpPostData)this.data).header_parameters_nrs[i])}));
                }
            }
            if (((HttpPostData)this.data).useBodyParameters) {
                for (i = 0; i < ((HttpPostData)this.data).body_parameters_nrs.length; ++i) {
                    String bodyParameterName = ((HttpPostData)this.data).bodyParameters[i].getName();
                    String bodyParameterValue = ((HttpPostData)this.data).inputRowMeta.getString(rowData, ((HttpPostData)this.data).body_parameters_nrs[i]);
                    ((HttpPostData)this.data).bodyParameters[i] = new BasicNameValuePair(bodyParameterName, bodyParameterValue);
                    if (!this.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.BodyValue", (String[])new String[]{bodyParameterName, bodyParameterValue}));
                }
                bodyParams = this.getRequestBodyParamsAsStr(((HttpPostData)this.data).bodyParameters, ((HttpPostData)this.data).realEncoding);
                post.setEntity((HttpEntity)new StringEntity(bodyParams, ContentType.TEXT_XML.withCharset("US-ASCII")));
            }
            if (((HttpPostData)this.data).useQueryParameters) {
                for (i = 0; i < ((HttpPostData)this.data).query_parameters_nrs.length; ++i) {
                    String queryParameterName = ((HttpPostData)this.data).queryParameters[i].getName();
                    String queryParameterValue = ((HttpPostData)this.data).inputRowMeta.getString(rowData, ((HttpPostData)this.data).query_parameters_nrs[i]);
                    ((HttpPostData)this.data).queryParameters[i] = new BasicNameValuePair(queryParameterName, queryParameterValue);
                    if (!this.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.QueryValue", (String[])new String[]{queryParameterName, queryParameterValue}));
                }
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(Arrays.asList(((HttpPostData)this.data).queryParameters)));
            }
            if (((HttpPostData)this.data).indexOfRequestEntity >= 0) {
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                String tmp = ((HttpPostData)this.data).inputRowMeta.getString(rowData, ((HttpPostData)this.data).indexOfRequestEntity);
                HttpEntity entity = null;
                byte[] bytes = null;
                if (((HttpPostMeta)this.meta).isPostAFile()) {
                    if (!tmp.isEmpty()) {
                        multipartEntityBuilder.addBinaryBody("file", HopVfs.getFileObject((String)this.resolve(tmp)).getPath().toFile());
                    }
                } else {
                    bytes = ((HttpPostData)this.data).realEncoding != null && ((HttpPostData)this.data).realEncoding.length() > 0 ? tmp.getBytes(((HttpPostData)this.data).realEncoding) : tmp.getBytes();
                    if (((HttpPostMeta)this.meta).isMultipartupload()) {
                        multipartEntityBuilder.addBinaryBody("file", bytes);
                        entity = multipartEntityBuilder.build();
                        post.setEntity(entity);
                    } else {
                        post.setEntity((HttpEntity)new ByteArrayEntity(bytes));
                    }
                }
            }
            Object[] newRow = null;
            if (rowData != null) {
                newRow = (Object[])rowData.clone();
            }
            CloseableHttpResponse httpResponse = null;
            try {
                String body;
                long startTime = System.currentTimeMillis();
                if (StringUtils.isNotBlank((String)((HttpPostData)this.data).realProxyHost)) {
                    HttpHost target = new HttpHost(((HttpPostData)this.data).realProxyHost, ((HttpPostData)this.data).realProxyPort, "http");
                    BasicAuthCache authCache = new BasicAuthCache();
                    BasicScheme basicAuth = new BasicScheme();
                    authCache.put(target, (AuthScheme)basicAuth);
                    HttpClientContext localContext = HttpClientContext.create();
                    localContext.setAuthCache((AuthCache)authCache);
                    httpResponse = httpClient.execute(target, (HttpRequest)post, (HttpContext)localContext);
                } else {
                    httpResponse = httpClient.execute((HttpUriRequest)post);
                }
                int statusCode = this.requestStatusCode((HttpResponse)httpResponse);
                long responseTime = System.currentTimeMillis() - startTime;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ResponseTime", (Object[])new Object[]{responseTime, ((HttpPostData)this.data).realUrl}));
                }
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ResponseCode", (String[])new String[]{String.valueOf(statusCode)}));
                }
                String headerString = "";
                switch (statusCode) {
                    case 401: {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.Authentication", (String[])new String[]{((HttpPostData)this.data).realUrl}));
                    }
                    case -1: {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.IllegalStatusCode", (String[])new String[]{((HttpPostData)this.data).realUrl}));
                    }
                    case 204: {
                        body = "";
                        break;
                    }
                    default: {
                        HttpEntity entity = httpResponse.getEntity();
                        body = entity != null ? EntityUtils.toString((HttpEntity)entity) : "";
                        Header[] headers = this.searchForHeaders((HttpResponse)httpResponse);
                        JSONObject json = new JSONObject();
                        for (Header header : headers) {
                            ArrayList<String> list;
                            Object previousValue = json.get((Object)header.getName());
                            if (previousValue == null) {
                                json.put((Object)header.getName(), (Object)header.getValue());
                                continue;
                            }
                            if (previousValue instanceof List) {
                                list = (ArrayList<String>)previousValue;
                                list.add(header.getValue());
                                continue;
                            }
                            list = new ArrayList<String>();
                            list.add((String)previousValue);
                            list.add(header.getValue());
                            json.put((Object)header.getName(), list);
                        }
                        headerString = json.toJSONString();
                    }
                }
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.ResponseBody", (String[])new String[]{body}));
                }
                int returnFieldsOffset = ((HttpPostData)this.data).inputRowMeta.size();
                if (!Utils.isEmpty((CharSequence)((HttpPostMeta)this.meta).getResultFields().get(0).getName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)body);
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)((HttpPostMeta)this.meta).getResultFields().get(0).getCode())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)statusCode);
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)((HttpPostMeta)this.meta).getResultFields().get(0).getResponseTimeFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)responseTime);
                    ++returnFieldsOffset;
                }
                if (!Utils.isEmpty((CharSequence)((HttpPostMeta)this.meta).getResultFields().get(0).getResponseHeaderFieldName())) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)headerString);
                }
            }
            finally {
                post.releaseConnection();
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            return newRow;
        }
        catch (UnknownHostException uhe) {
            throw new HopException(BaseMessages.getString(PKG, (String)"HTTPPOST.Error.UnknownHostException", (String[])new String[]{uhe.getMessage()}));
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"HTTPPOST.Error.CanNotReadURL", (String[])new String[]{((HttpPostData)this.data).realUrl}), (Throwable)e);
        }
    }

    protected int requestStatusCode(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    protected InputStreamReader openStream(String encoding, HttpResponse httpResponse) throws Exception {
        if (!Utils.isEmpty((CharSequence)encoding)) {
            return new InputStreamReader(httpResponse.getEntity().getContent(), encoding);
        }
        return new InputStreamReader(httpResponse.getEntity().getContent());
    }

    protected Header[] searchForHeaders(HttpResponse response) {
        return response.getAllHeaders();
    }

    public boolean processRow() throws HopException {
        block22: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int nrQuery;
                int nrargs;
                this.first = false;
                ((HttpPostData)this.data).inputRowMeta = this.getInputRowMeta();
                ((HttpPostData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((HttpPostMeta)this.meta).getFields(((HttpPostData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (((HttpPostMeta)this.meta).isUrlInField()) {
                    if (Utils.isEmpty((CharSequence)((HttpPostMeta)this.meta).getUrlField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.NoField", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"HTTPPOST.Log.NoField", (String[])new String[0]));
                    }
                    if (((HttpPostData)this.data).indexOfUrlField < 0) {
                        String realUrlfieldName = this.resolve(((HttpPostMeta)this.meta).getUrlField());
                        ((HttpPostData)this.data).indexOfUrlField = ((HttpPostData)this.data).inputRowMeta.indexOfValue(realUrlfieldName);
                        if (((HttpPostData)this.data).indexOfUrlField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)PKG_ERROR_FINDING_FIELD, (String[])new String[]{realUrlfieldName}));
                            throw new HopException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                        }
                    }
                } else {
                    ((HttpPostData)this.data).realUrl = this.resolve(((HttpPostMeta)this.meta).getUrl());
                }
                if ((nrargs = ((HttpPostMeta)this.meta).getLookupFields().get(0).getArgumentField().size()) > 0) {
                    ((HttpPostData)this.data).useBodyParameters = false;
                    ((HttpPostData)this.data).useHeaderParameters = false;
                    ((HttpPostData)this.data).contentTypeHeaderOverwrite = false;
                    int nrheader = 0;
                    int nrbody = 0;
                    for (int i = 0; i < nrargs; ++i) {
                        if (((HttpPostMeta)this.meta).getLookupFields().get(0).getArgumentField().get(i).isHeader()) {
                            ((HttpPostData)this.data).useHeaderParameters = true;
                            ++nrheader;
                            continue;
                        }
                        ((HttpPostData)this.data).useBodyParameters = true;
                        ++nrbody;
                    }
                    ((HttpPostData)this.data).header_parameters_nrs = new int[nrheader];
                    ((HttpPostData)this.data).headerParameters = new NameValuePair[nrheader];
                    ((HttpPostData)this.data).body_parameters_nrs = new int[nrbody];
                    ((HttpPostData)this.data).bodyParameters = new NameValuePair[nrbody];
                    int posHeader = 0;
                    int posBody = 0;
                    for (int i = 0; i < nrargs; ++i) {
                        int fieldIndex = ((HttpPostData)this.data).inputRowMeta.indexOfValue(((HttpPostMeta)this.meta).getLookupFields().get(0).getArgumentField().get(i).getName());
                        if (fieldIndex < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)PKG_ERROR_FINDING_FIELD, (String[])new String[0]) + ((HttpPostMeta)this.meta).getLookupFields().get(0).getArgumentField().get(i).getName() + "]");
                            throw new HopTransformException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.CouldnotFindField", (String[])new String[]{((HttpPostMeta)this.meta).getLookupFields().get(0).getArgumentField().get(i).getName()}));
                        }
                        if (((HttpPostMeta)this.meta).getLookupFields().get(0).getArgumentField().get(i).isHeader()) {
                            ((HttpPostData)this.data).header_parameters_nrs[posHeader] = fieldIndex;
                            ((HttpPostData)this.data).headerParameters[posHeader] = new BasicNameValuePair(this.resolve(((HttpPostMeta)this.meta).getLookupFields().get(0).getArgumentField().get(i).getParameter()), ((HttpPostData)this.data).outputRowMeta.getString(r, ((HttpPostData)this.data).header_parameters_nrs[posHeader]));
                            ++posHeader;
                            if (!CONTENT_TYPE.equalsIgnoreCase(((HttpPostMeta)this.meta).getLookupFields().get(0).getArgumentField().get(i).getParameter())) continue;
                            ((HttpPostData)this.data).contentTypeHeaderOverwrite = true;
                            continue;
                        }
                        ((HttpPostData)this.data).body_parameters_nrs[posBody] = fieldIndex;
                        ((HttpPostData)this.data).bodyParameters[posBody] = new BasicNameValuePair(this.resolve(((HttpPostMeta)this.meta).getLookupFields().get(0).getArgumentField().get(i).getParameter()), ((HttpPostData)this.data).outputRowMeta.getString(r, ((HttpPostData)this.data).body_parameters_nrs[posBody]));
                        ++posBody;
                    }
                }
                if ((nrQuery = ((HttpPostMeta)this.meta).getLookupFields().get(0).getQueryField().size()) > 0) {
                    ((HttpPostData)this.data).useQueryParameters = true;
                    ((HttpPostData)this.data).query_parameters_nrs = new int[nrQuery];
                    ((HttpPostData)this.data).queryParameters = new NameValuePair[nrQuery];
                    for (int i = 0; i < nrQuery; ++i) {
                        ((HttpPostData)this.data).query_parameters_nrs[i] = ((HttpPostData)this.data).inputRowMeta.indexOfValue(((HttpPostMeta)this.meta).getLookupFields().get(0).getQueryField().get(i).getName());
                        if (((HttpPostData)this.data).query_parameters_nrs[i] < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)PKG_ERROR_FINDING_FIELD, (String[])new String[0]) + ((HttpPostMeta)this.meta).getLookupFields().get(0).getQueryField().get(i).getName() + "]");
                            throw new HopTransformException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.CouldnotFindField", (String[])new String[]{((HttpPostMeta)this.meta).getLookupFields().get(0).getQueryField().get(i).getName()}));
                        }
                        ((HttpPostData)this.data).queryParameters[i] = new BasicNameValuePair(this.resolve(((HttpPostMeta)this.meta).getLookupFields().get(0).getQueryField().get(i).getParameter()), ((HttpPostData)this.data).outputRowMeta.getString(r, ((HttpPostData)this.data).query_parameters_nrs[i]));
                    }
                }
                if (!Utils.isEmpty((CharSequence)((HttpPostMeta)this.meta).getRequestEntity())) {
                    ((HttpPostData)this.data).indexOfRequestEntity = ((HttpPostData)this.data).inputRowMeta.indexOfValue(this.resolve(((HttpPostMeta)this.meta).getRequestEntity()));
                    if (((HttpPostData)this.data).indexOfRequestEntity < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"HTTPPOST.Exception.CouldnotFindRequestEntityField", (String[])new String[]{((HttpPostMeta)this.meta).getRequestEntity()}));
                    }
                }
                ((HttpPostData)this.data).realEncoding = this.resolve(((HttpPostMeta)this.meta).getEncoding());
            }
            try {
                Object[] outputRowData = this.callHttpPOST(r);
                this.putRow(((HttpPostData)this.data).outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"HTTPPOST.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"HTTPPOST.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block22;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "HTTPPOST001");
            }
        }
        return true;
    }

    @VisibleForTesting
    String getRequestBodyParamsAsStr(NameValuePair[] pairs, String charset) throws HopException {
        StringBuilder buf = new StringBuilder();
        try {
            for (int i = 0; i < pairs.length; ++i) {
                NameValuePair pair = pairs[i];
                if (pair.getName() == null) continue;
                if (i > 0) {
                    buf.append("&");
                }
                buf.append(URLEncoder.encode(pair.getName(), !StringUtil.isEmpty((String)charset) ? charset : "UTF-8"));
                buf.append("=");
                if (pair.getValue() == null) continue;
                buf.append(URLEncoder.encode(pair.getValue(), !StringUtil.isEmpty((String)charset) ? charset : "UTF-8"));
            }
            return buf.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new HopException(e.getMessage(), e.getCause());
        }
    }

    public boolean init() {
        if (super.init()) {
            ((HttpPostData)this.data).realProxyHost = this.resolve(((HttpPostMeta)this.meta).getProxyHost());
            ((HttpPostData)this.data).realProxyPort = Const.toInt((String)this.resolve(((HttpPostMeta)this.meta).getProxyPort()), (int)8080);
            ((HttpPostData)this.data).realHttpLogin = this.resolve(((HttpPostMeta)this.meta).getHttpLogin());
            ((HttpPostData)this.data).realHttpPassword = Utils.resolvePassword((IVariables)this.variables, (String)((HttpPostMeta)this.meta).getHttpPassword());
            ((HttpPostData)this.data).realSocketTimeout = Const.toInt((String)this.resolve(((HttpPostMeta)this.meta).getSocketTimeout()), (int)-1);
            ((HttpPostData)this.data).realConnectionTimeout = Const.toInt((String)this.resolve(((HttpPostMeta)this.meta).getSocketTimeout()), (int)-1);
            ((HttpPostData)this.data).realcloseIdleConnectionsTime = Const.toInt((String)this.resolve(((HttpPostMeta)this.meta).getCloseIdleConnectionsTime()), (int)-1);
            return true;
        }
        return false;
    }
}

