/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.util.Records;

public abstract class ValidateVolumeCapabilitiesRequest {
    public static ValidateVolumeCapabilitiesRequest newInstance(String volumeId, List<VolumeCapability> volumeCapabilities, Map<String, String> volumeAttributes) {
        ValidateVolumeCapabilitiesRequest request = Records.newRecord(ValidateVolumeCapabilitiesRequest.class);
        request.setVolumeId(volumeId);
        request.setVolumeAttributes(volumeAttributes);
        for (VolumeCapability capability : volumeCapabilities) {
            request.addVolumeCapability(capability);
        }
        return request;
    }

    public static ValidateVolumeCapabilitiesRequest newInstance(String volumeId, Map<String, String> volumeAttributes) {
        ValidateVolumeCapabilitiesRequest request = Records.newRecord(ValidateVolumeCapabilitiesRequest.class);
        request.setVolumeId(volumeId);
        request.setVolumeAttributes(volumeAttributes);
        return request;
    }

    public abstract void setVolumeId(String var1);

    public abstract String getVolumeId();

    public abstract void setVolumeAttributes(Map<String, String> var1);

    public abstract Map<String, String> getVolumeAttributes();

    public abstract void addVolumeCapability(VolumeCapability var1);

    public abstract List<VolumeCapability> getVolumeCapabilities();

    public static class VolumeCapability {
        private AccessMode mode;
        private VolumeType type;
        private List<String> flags;

        public VolumeCapability(AccessMode accessMode, VolumeType volumeType, List<String> mountFlags) {
            this.mode = accessMode;
            this.type = volumeType;
            this.flags = mountFlags;
        }

        public AccessMode getAccessMode() {
            return this.mode;
        }

        public VolumeType getVolumeType() {
            return this.type;
        }

        public List<String> getMountFlags() {
            return this.flags;
        }
    }

    public static enum VolumeType {
        BLOCK,
        FILE_SYSTEM;

    }

    public static enum AccessMode {
        UNKNOWN,
        SINGLE_NODE_WRITER,
        SINGLE_NODE_READER_ONLY,
        MULTI_NODE_READER_ONLY,
        MULTI_NODE_SINGLE_WRITER,
        MULTI_NODE_MULTI_WRITER;

    }
}

